/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.util;

import com.o3tt3rli.lang.RuntimeException;
import com.o3tt3rli.lang.XString;
import java.io.InputStream;

public class Base64 {
    public static final String ENCODING = "UTF8";

    public static String encode(byte[] bytes) {
        String result;
        if (bytes == null) {
            result = "";
        } else {
            StringBuffer encoded = new StringBuffer();
            int i = 0;
            int n = bytes.length;
            while (i < n) {
                encoded.append(Base64.encodeBlock(bytes, i));
                i += 3;
            }
            result = encoded.toString();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeStream(InputStream stream) {
        String string;
        try {
            try {
                byte[] contents = new byte[stream.available()];
                stream.read(contents);
                stream.close();
                string = Base64.encode(contents);
                Object var2_4 = null;
            }
            catch (Exception e) {
                throw new Base64Exception(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        stream.close();
        return string;
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        byte[] result = null;
        if (!XString.isSet(base64)) {
            result = new byte[]{};
        } else {
            int base64Len = base64.length();
            int i = base64Len - 1;
            while (base64.charAt(i) == '=') {
                ++pad;
                --i;
            }
            int length = base64Len * 6 / 8 - pad;
            result = new byte[length];
            int rawIndex = 0;
            int i2 = 0;
            while (i2 < base64Len) {
                int block = (Base64.getValue(base64.charAt(i2)) << 18) + (Base64.getValue(base64.charAt(i2 + 1)) << 12) + (Base64.getValue(base64.charAt(i2 + 2)) << 6) + Base64.getValue(base64.charAt(i2 + 3));
                int j = 0;
                while (j < 3 && rawIndex + j < length) {
                    result[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
                    ++j;
                }
                rawIndex += 3;
                i2 += 4;
            }
        }
        return result;
    }

    public static String encodeString(String raw) {
        try {
            return Base64.encode(raw.getBytes(ENCODING));
        }
        catch (Exception e) {
            throw new Base64Exception(e);
        }
    }

    public static String decodeToString(String base64) {
        try {
            return new String(Base64.decode(base64), ENCODING);
        }
        catch (Exception e) {
            throw new Base64Exception(e);
        }
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack >= 2 ? 2 : slack;
        int i = 0;
        while (i <= end) {
            int b = raw[offset + i];
            int neuter = b < 0 ? b + 256 : b;
            block += neuter << 8 * (2 - i);
            ++i;
        }
        char[] base64 = new char[4];
        int i2 = 0;
        while (i2 < 4) {
            int sixbit = block >>> 6 * (3 - i2) & 0x3F;
            base64[i2] = Base64.getChar(sixbit);
            ++i2;
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit <= 25) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit <= 51) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit <= 61) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }

    public static class Base64Exception
    extends RuntimeException {
        public Base64Exception(Throwable cause) {
            super(cause);
        }
    }
}

