/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.util;

import com.o3tt3rli.lang.Objects;
import com.o3tt3rli.lang.Tuple;
import com.o3tt3rli.lang.XString;

public class JavaStyle {
    public static final String NL = "\n";
    public static final String TAB = " ";
    public static final String TAB2 = "  ";
    private StringBuffer _value;
    private int _indent;
    private boolean _doIndent;
    private boolean _inComment;

    public JavaStyle(String s) {
        this();
        this.setValue(new StringBuffer(s));
    }

    public JavaStyle() {
        this.setIndent(0);
        this.setDoIndent();
        this.setInComment(false);
    }

    public JavaStyle beginComment(boolean nonJavadoc) {
        this.setInComment();
        return this.add(nonJavadoc ? "/* (non-Javadoc)" : "/**").nl();
    }

    public JavaStyle beginComment() {
        return this.beginComment(false);
    }

    public JavaStyle comment(String text) {
        return this.add(TAB).add(text);
    }

    public JavaStyle commentParam(String name, String comment) {
        return this.comment("@param ").add(name).blank().add(comment);
    }

    public JavaStyle commentReturn(String comment) {
        return this.comment("@return").blank().add(comment);
    }

    public JavaStyle ppublic() {
        return this.add("public").blank();
    }

    public JavaStyle pprivate() {
        return this.add("private").blank();
    }

    public JavaStyle pprotected() {
        return this.add("protected").blank();
    }

    public JavaStyle sstatic() {
        return this.add("static").blank();
    }

    public JavaStyle vvoid() {
        return this.add("void").blank();
    }

    public JavaStyle ffinal() {
        return this.add("final").blank();
    }

    public JavaStyle withParam(String param) {
        return this.withParams(new Tuple(param));
    }

    public JavaStyle withNoParams() {
        return this.withParams(null);
    }

    public JavaStyle withParams(Tuple params) {
        this.add("(");
        if (params != null) {
            this.add(params.toString(", "));
        }
        this.add(")");
        return this;
    }

    public JavaStyle memberConstant(String type, String name, String comment) {
        this.beginComment();
        this.comment(comment).nl();
        this.endComment();
        return this.ppublic().sstatic().ffinal().add(type).blank().add(name);
    }

    public JavaStyle assign() {
        return this.blank().add("=").blank();
    }

    public JavaStyle memberAssign(String member, String value) {
        return this.call("set" + XString.capitalize(member)).withParam(value).eos();
    }

    public JavaStyle memberGet(String member) {
        return this.call("get" + XString.capitalize(member)).withNoParams();
    }

    public JavaStyle assign(String value) {
        return this.assign().add(value);
    }

    public JavaStyle nnew(String clazz) {
        return this.add("new").blank().add(clazz);
    }

    public JavaStyle rreturn() {
        return this.add("return").blank();
    }

    public JavaStyle rreturn(String value) {
        return this.rreturn().add(value);
    }

    public JavaStyle ppackage(String name) {
        return this.add("package").blank().add(name).eos();
    }

    public JavaStyle iimport(String clazz) {
        return this.add("import").blank().add(clazz).eos();
    }

    public JavaStyle cclass(String name) {
        return this.add("class").blank().add(name);
    }

    public JavaStyle access(String access, String defaultAccess) {
        if (access == null) {
            access = defaultAccess;
        }
        if (access.length() > 0) {
            this.add(access).blank();
        }
        return this;
    }

    public JavaStyle constructor(String name) {
        return this.method(null, name);
    }

    public JavaStyle method(String returnType, String name) {
        if (returnType != null) {
            this.add(returnType).blank();
        }
        return this.add(name);
    }

    public JavaStyle noParams() {
        return this.params(null);
    }

    public JavaStyle param(Tuple param) {
        return this.params(new Tuple((Object)new Tuple((Object)param)));
    }

    public JavaStyle params(Tuple params) {
        this.add("(");
        if (params != null) {
            Tuple touple = new Tuple();
            Objects.Iterator aParams = params.iterator();
            while (aParams.hasNext()) {
                Tuple param = (Tuple)aParams.next();
                touple.add(param.toString());
            }
            this.add(touple.toString(", "));
        }
        return this.add(")");
    }

    public JavaStyle endComment() {
        this.setInComment(false);
        return this.add("/").nl();
    }

    public JavaStyle endBlock() {
        return this.endBlock(true);
    }

    public JavaStyle endBlock(boolean withNl) {
        this.unindent();
        JavaStyle aThis = this.add("}");
        if (withNl) {
            aThis = aThis.nl();
        }
        return aThis;
    }

    public JavaStyle beginBlock() {
        JavaStyle aThis = this.add(" {").nl();
        aThis.indent();
        return aThis;
    }

    public JavaStyle add(String value) {
        StringBuffer out = this.getValue();
        if (this.getDoIndent()) {
            this.setDoIndent(false);
            int i = 0;
            int nIndent = this.getIndent();
            while (i < nIndent) {
                out.append(TAB2);
                ++i;
            }
        }
        out.append(value);
        return this;
    }

    public JavaStyle nl() {
        JavaStyle o = this.add(NL);
        this.setDoIndent();
        if (this.getInComment()) {
            o = o.add(" *");
        }
        return o;
    }

    public JavaStyle blank() {
        return this.add(TAB);
    }

    public JavaStyle eos() {
        return this.add(";").nl();
    }

    public int getIndent() {
        return this._indent;
    }

    public String toString() {
        return this.getValue().toString();
    }

    public int indent() {
        int newIndent = this.getIndent() + 1;
        this.setIndent(newIndent);
        return newIndent;
    }

    public int unindent() {
        int newIndent = this.getIndent() - 1;
        this.setIndent(newIndent);
        return newIndent;
    }

    public StringBuffer getValue() {
        if (this._value == null) {
            this._value = new StringBuffer();
        }
        return this._value;
    }

    protected void setIndent(int indent) {
        this._indent = indent;
    }

    protected void setValue(StringBuffer value) {
        this._value = value;
    }

    protected void unsetValue() {
        this.setValue(null);
    }

    public boolean getDoIndent() {
        return this._doIndent;
    }

    protected void setDoIndent(boolean doIndent) {
        this._doIndent = doIndent;
    }

    public void setDoIndent() {
        this.setDoIndent(true);
    }

    public boolean getInComment() {
        return this._inComment;
    }

    protected void setInComment(boolean inComment) {
        this._inComment = inComment;
    }

    public void setInComment() {
        this.setInComment(true);
    }

    public JavaStyle doubleQuote() {
        return this.add("\"");
    }

    public JavaStyle quote() {
        return this.add("'");
    }

    public void reset() {
        this.unsetValue();
    }

    public int length() {
        return this.getValue().length();
    }

    public JavaStyle commentSee(String string) {
        return this.comment("@see").blank().add(string);
    }

    public JavaStyle call(String method) {
        return this.call(null, method);
    }

    public JavaStyle call(String object, String method) {
        if (object != null) {
            this.add(object).add(".");
        }
        return this.add(method);
    }

    public JavaStyle commentAuthor(String author, String comment) {
        this.comment("@author ").add(author);
        if (comment != null) {
            this.add(comment);
        }
        return this;
    }

    public JavaStyle commentAuthor(String author) {
        return this.commentAuthor(author, null);
    }

    public JavaStyle opAdd() {
        return this.add(" + ");
    }

    public JavaStyle opEquals() {
        return this.add(" == ");
    }

    public JavaStyle opNotEquals() {
        return this.add(" != ");
    }

    public JavaStyle opNotEquals(String value) {
        return this.opNotEquals().add(value);
    }

    public JavaStyle opEquals(String value) {
        return this.opEquals().add(value);
    }

    public JavaStyle eequals(String value) {
        return this.call("equals").withParam(value);
    }

    public JavaStyle eequals(String value, boolean nnative) {
        return nnative ? this.opEquals().add(value) : this.call("equals").withParam(value);
    }

    public JavaStyle opAdd(String value) {
        return this.add(" + ").add(value);
    }

    public JavaStyle opAnd(String value) {
        return this.add(" && ").add(value);
    }

    public JavaStyle beginCondition() {
        return this.add("(");
    }

    public JavaStyle endCondition() {
        return this.add(")");
    }

    public JavaStyle iif() {
        return this.add("if ");
    }

    public JavaStyle eelseif() {
        return this.add(" else if ");
    }

    public JavaStyle eelse() {
        return this.add(" else ");
    }

    public JavaStyle doubleQuote(String string) {
        return this.doubleQuote().add(string).doubleQuote();
    }

    public JavaStyle variable(String type, String name) {
        return this.add(type).blank().add(JavaStyle.makeVariableName(type, name));
    }

    public static String makeVariableName(String type, String name) {
        if (name == null) {
            name = JavaStyle.isPrimitive(type) ? type.substring(0, 1) : XString.uncapitalize(JavaStyle.className(type));
        }
        return name;
    }

    public JavaStyle variable(String type) {
        return this.variable(type, null);
    }

    public JavaStyle tthrow(String exception) {
        return this.add("throw ").nnew(exception);
    }

    public static String className(String fullQualifiedClass) {
        int lastDot = fullQualifiedClass.lastIndexOf(46);
        return lastDot != -1 ? fullQualifiedClass.substring(lastDot + 1) : fullQualifiedClass;
    }

    public static String packageName(String fullQualifiedClass) {
        int lastDot = fullQualifiedClass.lastIndexOf(46);
        return lastDot != -1 ? fullQualifiedClass.substring(0, lastDot) : null;
    }

    public static String packageDeclaration(String pkg) {
        return XString.isSet(pkg) ? "package " + pkg + ";" : "";
    }

    public JavaStyle fileComment(String fullQualifiedClass, String commentBody) {
        this.beginComment();
        this.comment("File Name: ").add(JavaStyle.compilationUnitName(JavaStyle.className(fullQualifiedClass))).nl();
        this.nl();
        this.comment(commentBody).nl();
        this.nl();
        this.comment("Version: $Id: $").nl();
        this.endComment();
        return this;
    }

    public JavaStyle beginCompilationUnit(String fullQualifiedClass, String fileCommentBody) {
        this.fileComment(fullQualifiedClass, fileCommentBody);
        String pack = JavaStyle.packageName(fullQualifiedClass);
        if (XString.isSet(pack)) {
            this.ppackage(pack);
            this.nl();
        }
        return this;
    }

    public static String compilationUnitName(String clazz) {
        return String.valueOf(clazz) + ".java";
    }

    public JavaStyle typeParam(String type) {
        return this.add(" < ").add(type).add(" > ");
    }

    public JavaStyle eextends(String type) {
        return this.add(" extends ").add(type).blank();
    }

    public JavaStyle iimplements(String type) {
        return this.add(" implements ").add(type).blank();
    }

    public JavaStyle cast(String clazz) {
        return this.add("(").add(clazz).add(")");
    }

    public static String decorateName(String name) {
        return String.valueOf(name.charAt(0)) + name;
    }

    public JavaStyle aabstract() {
        return this.add("abstract ");
    }

    public JavaStyle ssuper() {
        return this.add("super");
    }

    public JavaStyle commentThrows(String exception) {
        return this.add(" @throws ").add(exception);
    }

    public static String toRefType(String type) {
        String refType = JavaStyle.isPrimitive(type) ? (type.equals("int") ? "Integer" : (type.equals("char") ? "Character" : XString.capitalize(type))) : type;
        return refType;
    }

    public static boolean isPrimitive(String type) {
        return "int".equals(type) || "boolean".equals(type) || "char".equals(type) || "float".equals(type) || "double".equals(type) || "long".equals(type);
    }

    public static String box(String type, String expr) {
        String result;
        if (JavaStyle.isPrimitive(type)) {
            String refType = JavaStyle.toRefType(type);
            result = "new " + refType + "(" + expr + ")";
        } else {
            result = expr;
        }
        return result;
    }

    public static String unbox(String type, String expr) {
        String result;
        if (JavaStyle.isPrimitive(type)) {
            String refType = JavaStyle.toRefType(type);
            result = "((" + refType + ")" + expr + ")." + type + "Value()";
        } else {
            result = expr;
        }
        return result;
    }

    public static String toPlural(String name) {
        if (name.endsWith("y")) {
            name = String.valueOf(name.substring(0, name.length() - 1)) + "ie";
        } else if (name.endsWith("s")) {
            name = String.valueOf(name) + "e";
        }
        name = String.valueOf(name) + "s";
        return name;
    }

    public static String nullFor(String type) {
        return JavaStyle.isPrimitive(type) ? (type.equals("boolean") ? "false" : "0") : "null";
    }

    public static String accessor(String accessor, String name) {
        return String.valueOf(accessor) + XString.capitalize(name);
    }
}

