/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.xml;

import com.o3tt3rli.xml.XmlException;
import com.o3tt3rli.xml.XmlNodeNotFoundException;
import com.o3tt3rli.xml.XmlNodes;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractElement;
import org.xml.sax.InputSource;

public class XmlNode {
    private Node _node;

    protected static SAXReader createSAXReader() {
        return new SAXReader();
    }

    public XmlNode() {
    }

    public XmlNode(Node node) {
        this.setNode(node);
    }

    public XmlNode(XmlNode other) {
        this(other.getNode());
    }

    public XmlNode(File file) {
        try {
            this.setNode((Node)XmlNode.createSAXReader().read(file));
            this.setNodeToDocumentElement();
        }
        catch (Exception e) {
            throw new XmlException(e);
        }
    }

    public XmlNode(InputSource inputSource) {
        try {
            this.setNode((Node)XmlNode.createSAXReader().read(inputSource));
            this.setNodeToDocumentElement();
        }
        catch (Exception e) {
            throw new XmlException(e);
        }
    }

    public XmlNode(InputStream inputStream) {
        try {
            this.setNode((Node)XmlNode.createSAXReader().read(inputStream));
            this.setNodeToDocumentElement();
        }
        catch (Exception de) {
            throw new XmlException(de);
        }
    }

    public XmlNode(Reader reader) {
        try {
            this.setNode((Node)XmlNode.createSAXReader().read(reader));
            this.setNodeToDocumentElement();
        }
        catch (Exception de) {
            throw new XmlException(de);
        }
    }

    public XmlNode(URL url) {
        this.parse(url);
    }

    public XmlNode(String rootElement) {
        this.newDocument(rootElement);
    }

    public XmlNode(String xml, boolean parse) {
        this.parse(xml);
    }

    public void newDocument() {
        this.setNode((Node)DocumentHelper.createDocument());
    }

    public void parse(String xml) {
        try {
            this.setNode((Node)XmlNode.createSAXReader().read((Reader)new StringReader(xml)));
            this.setNodeToDocumentElement();
        }
        catch (Exception e) {
            throw new XmlException(e);
        }
    }

    public void parse(URL url) {
        try {
            this.setNode((Node)XmlNode.createSAXReader().read(url));
            this.setNodeToDocumentElement();
        }
        catch (Exception e) {
            throw new XmlException(e);
        }
    }

    public void newDocument(String documentElement) {
        this.newDocument();
        this.getNode().getDocument().addElement(documentElement);
        this.setNodeToDocumentElement();
    }

    public void setNodeToDocumentElement() {
        this.setNode(this.getDocumentElement().getNode());
    }

    public XmlNode addOnce(String elementName) {
        XmlNode node = this.get(elementName, null);
        if (node == null) {
            node = this.add(elementName);
        }
        return node;
    }

    public XmlNode add(String name) {
        return new XmlNode((Node)this.asElement().addElement(name));
    }

    public XmlNode add(XmlNode other) {
        this.asElement().add(other.getNode());
        return other;
    }

    public void addChildren(XmlNode other) {
        final Element aThis = this.asElement();
        other.getAllElementsAndAttributes().forEach(new XmlNodes.Method(){

            public void run(XmlNode xmlNode) {
                aThis.add(xmlNode.getNode().detach());
            }
        });
    }

    public XmlNodes getAll() {
        return XmlNodes.create(this.asElement().elements());
    }

    public XmlNodes getAll(String elementName) {
        return XmlNodes.create(this.asElement().elements(elementName));
    }

    public XmlNode get(String elementName, XmlNode defaultValue) {
        Element element = this.asElement().element(elementName);
        return element == null ? defaultValue : new XmlNode((Node)element);
    }

    public boolean has(String elementName) {
        return this.get(elementName, null) != null;
    }

    public XmlNode get(String elementName) {
        XmlNode node = this.get(elementName, null);
        if (node == null) {
            throw new XmlNodeNotFoundException(elementName);
        }
        return node;
    }

    public XmlNode getFirstChild() {
        XmlNode node = this.getFirstChild(null);
        if (node == null) {
            throw new XmlNodeNotFoundException("<first child>");
        }
        return node;
    }

    public XmlNode getFirstChild(XmlNode defaultValue) {
        XmlNode kid = null;
        if (this.isRoot()) {
            kid = this.getDocumentElement();
        } else {
            List kids = this.asElement().elements();
            if (!kids.isEmpty()) {
                kid = new XmlNode((Node)kids.get(0));
            }
        }
        if (kid == null) {
            kid = defaultValue;
        }
        return kid;
    }

    public XmlNode getParentNode() {
        Element parent = this.getNode().getParent();
        return parent != null ? new XmlNode((Node)parent) : this.getRoot();
    }

    public XmlNode getDocumentElement() {
        return new XmlNode((Node)this.getNode().getDocument().getRootElement());
    }

    public XmlNode getRoot() {
        return new XmlNode(this.getDocument());
    }

    public void remove() {
        Node self = this.getNode();
        self.getParent().remove(self);
    }

    public void save(File file) {
        try {
            XMLWriter xmlWriter = new XMLWriter((Writer)new FileWriter(file), OutputFormat.createCompactFormat());
            xmlWriter.write(this.getNode());
            xmlWriter.flush();
        }
        catch (Exception e) {
            throw new XmlException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof XmlNode && ((XmlNode)obj).getUniquePath().equals(this.getUniquePath());
    }

    public int hashCode() {
        return this.getUniquePath().hashCode();
    }

    public boolean isDocumentElement() {
        return this.equals(this.getDocumentElement());
    }

    public boolean isRoot() {
        return this.equals(this.getRoot());
    }

    public String getAttribute(String name, String defaultValue) {
        String attr = this.asElement().attributeValue(name);
        return attr != null ? attr : defaultValue;
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name, null) != null;
    }

    public String getAttribute(String name) {
        if (!this.hasAttribute(name)) {
            throw new XmlNodeNotFoundException("@" + name);
        }
        return this.getAttribute(name, null);
    }

    public XmlNode setAttribute(String name, String value) {
        this.asElement().addAttribute(name, value);
        return this.getAttributeNode(name);
    }

    public XmlNode getAttributeNode(String name) {
        XmlNode node = this.getAttributeNode(name, null);
        if (node == null) {
            throw new XmlNodeNotFoundException("@" + name);
        }
        return node;
    }

    public XmlNode getAttributeNode(String name, XmlNode defaultValue) {
        Attribute node = this.asElement().attribute(name);
        return node != null ? new XmlNode((Node)node) : defaultValue;
    }

    public XmlNodes getAllAttributes() {
        return XmlNodes.create(this.asElement().attributes());
    }

    public Element asElement() {
        return (Element)this.getNode();
    }

    public Attribute asAttribute() {
        return (Attribute)this.getNode();
    }

    public String toPrettyXml() {
        return this.toPrettyXml(null);
    }

    public String toPrettyXml(OutputFormat format) {
        try {
            if (format == null) {
                format = OutputFormat.createPrettyPrint();
            }
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, format);
            xmlWriter.write(this.getNode());
            xmlWriter.flush();
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new XmlException(e);
        }
    }

    public DocumentSource getSource() {
        return new DocumentSource(this.getNode());
    }

    public InputSource getInputSource() {
        return this.getSource().getInputSource();
    }

    public XmlNode getParent() {
        return new XmlNode((Node)this.getNode().getParent());
    }

    public int getIndex() {
        int index = 0;
        if (this.isElement() && !this.isDocumentElement()) {
            Element aThis = this.asElement();
            List siblings = this.getParent().asElement().elements(aThis.getQName());
            if (siblings.size() > 1) {
                index = siblings.indexOf(aThis);
            }
        }
        return index + 1;
    }

    public String toXml() {
        return this.getNode().asXML();
    }

    public Object clone() {
        return new XmlNode((Node)this.getNode().clone());
    }

    public XmlNode getDocument() {
        return new XmlNode((Node)this.getNode().getDocument());
    }

    public Node detach() {
        return this.getNode().detach();
    }

    public Reader getReader() {
        return this.getInputSource().getCharacterStream();
    }

    public boolean isAttribute() {
        return this.isOfType((short)2);
    }

    public boolean isElement() {
        return this.isOfType((short)1);
    }

    public boolean isDocument() {
        return this.isOfType((short)9);
    }

    public boolean isOfType(short type) {
        return this.getNodeType() == type;
    }

    public short getNodeType() {
        return this.getNode().getNodeType();
    }

    public String getNodeTypeName() {
        return this.getNode().getNodeTypeName();
    }

    public String getPath() {
        return this.getNode().getPath();
    }

    public String getPath(XmlNode other) {
        return this.getNode().getPath(other.asElement());
    }

    public String getUniquePath() {
        return this.getNode().getUniquePath();
    }

    public String getUniquePath(XmlNode other) {
        return this.getNode().getUniquePath(other.asElement());
    }

    public boolean isTrue() {
        String text = this.getValue();
        return Boolean.TRUE.toString().equals(text) || "1".equals(text);
    }

    public String getValue() {
        return this.getNode().getText();
    }

    public String getName() {
        return this.getNode().getName();
    }

    public void setValue(String value) {
        this.getNode().setText(value);
    }

    public boolean isFalse() {
        return !this.isTrue();
    }

    public void setTrue() {
        this.setValue(String.valueOf(true));
    }

    public void setFalse() {
        this.setValue(String.valueOf(false));
    }

    public Node getNode() {
        return this._node;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    public String getValue(String name) {
        return this.get(name).getValue();
    }

    public String getValue(String name, String defaultValue) {
        return this.has(name) ? this.getValue(name) : defaultValue;
    }

    public XmlNode selectFirst(String xpath) {
        Node node = this.getNode().selectSingleNode(xpath);
        if (node == null) {
            throw new XmlNodeNotFoundException(xpath);
        }
        return new XmlNode(node);
    }

    public XmlNode selectFirst(String xpath, XmlNode defaultValue) {
        Node node = this.getNode().selectSingleNode(xpath);
        return node != null ? new XmlNode(node) : defaultValue;
    }

    public String selectValue(String xpath) {
        return this.selectFirst(xpath).getValue();
    }

    public String selectValue(String xpath, String defaultValue) {
        XmlNode first = this.selectFirst(xpath, null);
        return first != null ? first.getValue() : defaultValue;
    }

    public XmlNodes select(String xpath) {
        return XmlNodes.create(this.getNode().selectNodes(xpath));
    }

    public void removeNamespace() {
        this.getAll().forEach(new XmlNodes.Method(){

            public void run(XmlNode xmlNode) {
                xmlNode.removeNamespace();
            }
        });
        ((AbstractElement)this.asElement()).setNamespace(null);
    }

    public XmlNodes getAllElementsAndAttributes() {
        XmlNodes result = new XmlNodes(this.getAll());
        result.addAll(this.getAllAttributes());
        return result;
    }

    public boolean exists(String xpath) {
        return this.selectFirst(xpath, null) != null;
    }
}

