/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.eclipse.ui.model;

import com.o3tt3rli.eclipse.ui.model.IValue;
import com.o3tt3rli.eclipse.ui.model.IValueChangedListener;
import com.o3tt3rli.eclipse.ui.model.Problem;
import com.o3tt3rli.eclipse.ui.model.ProblemSeverity;
import com.o3tt3rli.eclipse.ui.model.Problems;
import com.o3tt3rli.eclipse.ui.model.ValueChangedListeners;
import com.o3tt3rli.eclipse.ui.widgets.IControlVisitor;
import com.o3tt3rli.eclipse.ui.widgets.XControl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class ModelControlBinding {
    private static Color _errorColor;
    private static Color _warningColor;
    public static final String BOUND_CONTROL_DATA_KEY;
    private Boolean _doEvents;
    private Control _control;
    private IValue _value;
    private ValueChangedListeners _valueChangedListeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.o3tt3rli.eclipse.ui.model.ModelControlBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BOUND_CONTROL_DATA_KEY = clazz.getName();
    }

    public static boolean isBoundControl(Control control) {
        return control.getData(BOUND_CONTROL_DATA_KEY) instanceof ModelControlBinding;
    }

    public static void addValueChangedListener(Control control, final IValueChangedListener listener) {
        XControl.accept(control, new IControlVisitor(){

            public boolean visit(Control control) {
                if (ModelControlBinding.isBoundControl(control)) {
                    ModelControlBinding mcb = (ModelControlBinding)control.getData(BOUND_CONTROL_DATA_KEY);
                    mcb.addValueChangedListener(listener);
                }
                return true;
            }
        });
    }

    public Problems getProblems(boolean firstOnly) {
        return ModelControlBinding.getProblems(this.getControl(), firstOnly);
    }

    public static Problems getProblems(Control control, final boolean firstOnly) {
        final Problems result = new Problems();
        XControl.accept(control, new IControlVisitor(){

            public boolean visit(Control control) {
                boolean go = true;
                if (ModelControlBinding.isBoundControl(control)) {
                    ModelControlBinding mcb = (ModelControlBinding)control.getData(BOUND_CONTROL_DATA_KEY);
                    result.addAll(mcb.getValue().getProblems(firstOnly));
                    if (!result.isEmpty() && firstOnly) {
                        go = false;
                    }
                }
                return go;
            }
        });
        return result;
    }

    protected boolean hasBinding() {
        return this.getValue() != null && this.getControl() != null;
    }

    protected abstract void unbind();

    protected void bind(IValue value, Control control) {
        if (this.hasBinding()) {
            this.unbind();
        }
        this.setValue(value);
        this.setControl(control);
        control.setData(BOUND_CONTROL_DATA_KEY, (Object)this);
    }

    protected abstract void doDataExchange(boolean var1);

    public Control getControl() {
        return this._control;
    }

    protected void setControl(Control control) {
        this._control = control;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runWithoutEvents(Runnable runnable) {
        try {
            this.setDoEvents(false);
            runnable.run();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.setDoEvents(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.setDoEvents(true);
            return;
        }
    }

    public boolean getDoEvents() {
        if (this._doEvents == null) {
            this._doEvents = Boolean.TRUE;
        }
        return this._doEvents;
    }

    public void setDoEvents(boolean doEvents) {
        this._doEvents = doEvents;
    }

    protected void doDataExchangeWithoutEvents(final boolean saveAndValidate) {
        this.runWithoutEvents(new Runnable(){

            public void run() {
                ModelControlBinding.this.doDataExchange(saveAndValidate);
                ModelControlBinding.this.updateStatus();
            }
        });
    }

    public IValue getValue() {
        return this._value;
    }

    protected void setValue(IValue value) {
        this._value = value;
    }

    public void addValueChangedListener(IValueChangedListener listener) {
        this.getValueChangedListeners().add(listener);
    }

    public void removeValueChangedListener(IValueChangedListener listener) {
        this.getValueChangedListeners().remove(listener);
    }

    protected void onControlContentChanged() {
        if (this.getDoEvents()) {
            this.doDataExchangeWithoutEvents(true);
            this.fireValueChanged();
        }
    }

    public static void applyStatus(Control control, Problem problem) {
        ProblemSeverity severity = problem.getSeverity();
        boolean isError = severity.isError();
        boolean isWarning = severity.isWarning();
        Color color = isWarning ? ModelControlBinding.getWarningColor() : (isError ? ModelControlBinding.getErrorColor() : control.getDisplay().getSystemColor(25));
        control.setBackground(color);
        control.redraw();
        control.setToolTipText(isError || isWarning ? problem.getText() : "");
    }

    public void updateStatus() {
        Problems problems = this.getProblems(true);
        ModelControlBinding.applyStatus(this.getControl(), problems.isEmpty() ? Problem.NONE : problems.getFirst());
    }

    public ValueChangedListeners getValueChangedListeners() {
        if (this._valueChangedListeners == null) {
            this._valueChangedListeners = new ValueChangedListeners();
        }
        return this._valueChangedListeners;
    }

    protected void fireValueChanged() {
        ValueChangedListeners.Iterator all = this.getValueChangedListeners().iterator();
        while (all.hasNext()) {
            all.next().changed();
        }
    }

    public static Color getErrorColor() {
        if (_errorColor == null) {
            _errorColor = new Color((Device)Display.getDefault(), 255, 105, 105);
        }
        return _errorColor;
    }

    public static Color getWarningColor() {
        if (_warningColor == null) {
            _warningColor = new Color((Device)Display.getDefault(), 255, 255, 171);
        }
        return _warningColor;
    }
}

