/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.eclipse.ui.model;

import com.o3tt3rli.eclipse.ui.model.IValueChangedListener;
import com.o3tt3rli.eclipse.ui.model.ModelControlBinding;
import com.o3tt3rli.eclipse.ui.model.Problem;
import com.o3tt3rli.eclipse.ui.model.ProblemSeverity;
import com.o3tt3rli.eclipse.ui.model.Problems;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Control;

public abstract class ModelWizardPage
extends WizardPage {
    private IValueChangedListener _valueChangedListener;

    public ModelWizardPage(String pageName) {
        super(pageName);
    }

    public Problem getStatus() {
        Problems problems = ModelControlBinding.getProblems(this.getControl(), true);
        return problems.isEmpty() ? Problem.NONE : problems.getFirst();
    }

    public void updateStatus() {
        if (this.isControlCreated()) {
            Problem status = this.getStatus();
            this.applyToStatusLine(status);
        }
    }

    protected void applyToStatusLine(Problem status) {
        ProblemSeverity severity = status.getSeverity();
        if (severity.isError()) {
            this.setMessage(null);
            this.setErrorMessage(status.getText());
        } else if (severity.isWarning()) {
            this.setMessage(status.getText(), 2);
            this.setErrorMessage(null);
        } else {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(status.getSeverity().canContinue());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateStatus();
        }
    }

    protected void setControl(Control control) {
        super.setControl(control);
        ModelControlBinding.addValueChangedListener(control, this.getValueChangedListener());
    }

    public IValueChangedListener getValueChangedListener() {
        if (this._valueChangedListener == null) {
            this._valueChangedListener = new IValueChangedListener(){

                public void changed() {
                    ModelWizardPage.this.updateStatus();
                }
            };
        }
        return this._valueChangedListener;
    }
}

