/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.eclipse.ui.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ProblemSeverity {
    public static final None none = new None();
    public static final Error error = new Error();
    public static final Warning warning = new Warning();
    private static Map _name2ItemMap;
    private static List _all;

    protected ProblemSeverity() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static ProblemSeverity valueOf(String name, ProblemSeverity defaultValue) {
        Map map = ProblemSeverity.getName2ItemMap();
        ProblemSeverity item = map.containsKey(name) ? (ProblemSeverity)map.get(name) : defaultValue;
        return item;
    }

    public static ProblemSeverity valueOf(String name) {
        ProblemSeverity i_t_e_m = ProblemSeverity.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, ProblemSeverity> map = new HashMap<String, ProblemSeverity>();
            Iterator all = ProblemSeverity.getAll().iterator();
            while (all.hasNext()) {
                ProblemSeverity item = (ProblemSeverity)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isNone() {
        return this.equals(none);
    }

    public boolean isError() {
        return this.equals(error);
    }

    public boolean isWarning() {
        return this.equals(warning);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(none, error, warning);
        }
        return _all;
    }

    public boolean canContinue() {
        return !this.isError();
    }

    public static class None
    extends ProblemSeverity {
        protected None() {
        }

        public String getName() {
            return "none";
        }
    }

    public static class Error
    extends ProblemSeverity {
        protected Error() {
        }

        public String getName() {
            return "error";
        }
    }

    public static class Warning
    extends ProblemSeverity {
        protected Warning() {
        }

        public String getName() {
            return "warning";
        }
    }
}

