/*
 * Decompiled with CFR 0.152.
 */
package com.o3tt3rli.eclipse.ui.widgets;

import java.io.File;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class XFileDialog {
    public static String openDirectoryDialog(Shell shell, File initialFile) {
        return XFileDialog.openDialog((Dialog)new DirectoryDialog(shell), initialFile, null, null);
    }

    public static String openFileDialog(Shell shell, File initialFile, int style, String[] filterExtensions, String[] filterNames) {
        return XFileDialog.openDialog((Dialog)new FileDialog(shell, style), initialFile, filterExtensions, filterNames);
    }

    public static String getParentName(File file) {
        File parent = file.isDirectory() ? file : file.getParentFile();
        return parent != null ? parent.toString() : null;
    }

    protected static String openDialog(Dialog dlg, File initialFile, String[] filterExtensions, String[] filterNames) {
        String result;
        String parentName;
        DirectoryDialog dd = dlg instanceof DirectoryDialog ? (DirectoryDialog)dlg : null;
        FileDialog fd = dlg instanceof FileDialog ? (FileDialog)dlg : null;
        String string = parentName = initialFile != null ? XFileDialog.getParentName(initialFile) : null;
        if (parentName != null) {
            if (dd != null) {
                dd.setFilterPath(parentName);
            } else {
                fd.setFilterPath(parentName);
            }
        }
        if (dd != null) {
            result = dd.open();
        } else {
            if ((fd.getStyle() & 0x1000) == 0 && initialFile != null) {
                fd.setFileName(XFileDialog.getNextFile(initialFile).getName());
            }
            if (filterExtensions != null) {
                fd.setFilterExtensions(filterExtensions);
            }
            if (filterNames != null) {
                fd.setFilterNames(filterNames);
            }
            result = fd.open();
        }
        return result != null ? result.replace('\\', '/') : null;
    }

    public static File getNextFile(File file) {
        String ext;
        String parent = file.getParent();
        String fileName = file.getName();
        int extPos = fileName.indexOf(46);
        if (extPos != -1) {
            ext = fileName.substring(extPos, fileName.length());
            fileName = fileName.substring(0, extPos);
        } else {
            ext = "";
        }
        File result = file;
        int i = 1;
        while (result.exists()) {
            result = new File(parent, String.valueOf(fileName) + " (" + i + ")" + ext);
            ++i;
        }
        return result;
    }
}

