/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpplayer.IPlayer;
import mpplayer.MpplayerException;
import mpplayer.resource.Resource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public abstract class ExternalPlayer {
    public static final Wmp wmp = new Wmp();
    public static final RealOne realOne = new RealOne();
    private static Map _name2ItemMap;
    private static List _all;
    private Image _image;
    private static Image _imageNone;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected ExternalPlayer() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static ExternalPlayer valueOf(String name, ExternalPlayer defaultValue) {
        Map map = ExternalPlayer.getName2ItemMap();
        ExternalPlayer item = map.containsKey(name) ? (ExternalPlayer)map.get(name) : defaultValue;
        return item;
    }

    public static ExternalPlayer valueOf(String name) {
        ExternalPlayer i_t_e_m = ExternalPlayer.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, ExternalPlayer> map = new HashMap<String, ExternalPlayer>();
            Iterator all = ExternalPlayer.getAll().iterator();
            while (all.hasNext()) {
                ExternalPlayer item = (ExternalPlayer)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isWmp() {
        return this.equals(wmp);
    }

    public boolean isRealOne() {
        return this.equals(realOne);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(wmp, realOne);
        }
        return _all;
    }

    /*
     * WARNING - void declaration
     */
    public String getProgId() {
        void var1_1;
        String id;
        if (this.isWmp()) {
            id = "WMPlayer.OCX";
        } else if (this.isRealOne()) {
            id = "rmocx.RealPlayer G2 Control.1";
        } else {
            throw new MpplayerException("no prog ids defined for external player: " + this.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String getTitle() {
        void var1_1;
        String title;
        if (this.isWmp()) {
            title = "Windows Media Player";
        } else if (this.isRealOne()) {
            title = "RealOne Player";
        } else {
            throw new MpplayerException("no title defined for external player: " + this.getName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Class getPlayerClass() {
        void var1_1;
        Class<?> c;
        if (this.isWmp()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mpplayer.win32.wmp.Wmp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            c = clazz;
        } else if (this.isRealOne()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("mpplayer.win32.realone.RealOne");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            c = clazz;
        } else {
            throw new MpplayerException("no player class defined for external player: " + this.getName());
        }
        return var1_1;
    }

    public IPlayer create(Composite parent, int style) {
        try {
            Class clazz = this.getPlayerClass();
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.swt.widgets.Composite");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            classArray[1] = Integer.TYPE;
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz3;
            return (IPlayer)clazz.getConstructor(classArray).newInstance(parent, new Integer(style), this.getProgId());
        }
        catch (Exception e) {
            throw new MpplayerException(e);
        }
    }

    public Image getImage() {
        if (this._image == null) {
            this._image = Resource.valueOf(this.getName()).createImage();
        }
        return this._image;
    }

    public static Image getImageDiscover() {
        if (_imageNone == null) {
            _imageNone = Resource.playerDiscover.createImage();
        }
        return _imageNone;
    }

    public static class Wmp
    extends ExternalPlayer {
        protected Wmp() {
        }

        public String getName() {
            return "wmp";
        }
    }

    public static class RealOne
    extends ExternalPlayer {
        protected RealOne() {
        }

        public String getName() {
            return "realOne";
        }
    }
}

