/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class JoystickDirection {
    public static final Right right = new Right();
    public static final Left left = new Left();
    public static final Up up = new Up();
    public static final Down down = new Down();
    private static Map _name2ItemMap;
    private static List _all;

    protected JoystickDirection() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static JoystickDirection valueOf(String name, JoystickDirection defaultValue) {
        Map map = JoystickDirection.getName2ItemMap();
        JoystickDirection item = map.containsKey(name) ? (JoystickDirection)map.get(name) : defaultValue;
        return item;
    }

    public static JoystickDirection valueOf(String name) {
        JoystickDirection i_t_e_m = JoystickDirection.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, JoystickDirection> map = new HashMap<String, JoystickDirection>();
            Iterator all = JoystickDirection.getAll().iterator();
            while (all.hasNext()) {
                JoystickDirection item = (JoystickDirection)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isRight() {
        return this.equals(right);
    }

    public boolean isLeft() {
        return this.equals(left);
    }

    public boolean isUp() {
        return this.equals(up);
    }

    public boolean isDown() {
        return this.equals(down);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(right, left, up, down);
        }
        return _all;
    }

    public static class Right
    extends JoystickDirection {
        protected Right() {
        }

        public String getName() {
            return "right";
        }
    }

    public static class Left
    extends JoystickDirection {
        protected Left() {
        }

        public String getName() {
            return "left";
        }
    }

    public static class Up
    extends JoystickDirection {
        protected Up() {
        }

        public String getName() {
            return "up";
        }
    }

    public static class Down
    extends JoystickDirection {
        protected Down() {
        }

        public String getName() {
            return "down";
        }
    }
}

