/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import com.o3tt3rli.eclipse.ui.wizard.XWizardDialog;
import com.o3tt3rli.lang.XString;
import com.o3tt3rli.util.Favorites;
import com.o3tt3rli.xml.XmlNode;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import mpplayer.Command;
import mpplayer.CommandsTableContentProvider;
import mpplayer.CommandsTableLabelProvider;
import mpplayer.ExternalPlayer;
import mpplayer.Frame;
import mpplayer.IPlayer;
import mpplayer.IPlayerListener;
import mpplayer.JoystickDirection;
import mpplayer.MarkersTableContentProvider;
import mpplayer.MarkersTableLabelProvider;
import mpplayer.Message;
import mpplayer.MouseSleepCounter;
import mpplayer.MpplayerException;
import mpplayer.MpplayerPlugin;
import mpplayer.MyJoystick;
import mpplayer.PlayListTableContentProvider;
import mpplayer.PlayListTableLabelProvider;
import mpplayer.PlayState;
import mpplayer.PlayerSelectionWizard;
import mpplayer.ScaleContentProvider;
import mpplayer.SettingsWizard;
import mpplayer.UpdateCmdUi;
import mpplayer.lang.PointProperty;
import mpplayer.model.Marker;
import mpplayer.model.MarkerPosition;
import mpplayer.model.MarkerPositions;
import mpplayer.model.Markers;
import mpplayer.model.MarkersDocument;
import mpplayer.model.PlayListDocument;
import mpplayer.model.Player;
import mpplayer.model.PlayerActiveState;
import mpplayer.model.PlayerAvailableState;
import mpplayer.model.Players;
import mpplayer.model.RecentPlayLists;
import mpplayer.model.RecentPlayListsDocument;
import mpplayer.model.SettingsDocument;
import mpplayer.model.Track;
import mpplayer.model.Tracks;
import mpplayer.playlist.PlayListReader;
import mpplayer.resource.Resource;
import mpplayer.widgets.Scale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.dialogs.AboutDialog;

public class Main {
    private static Main _instance;
    private MyJoystick _joy;
    public static final String FORMAT_MARKER_POSITION = "{0,number,0.00}";
    public static final int JOY_TIMER_INTERVAL = 500;
    public static final String MARKERS_FILE = "markers.xml";
    public static final String PLAYLIST_FILE = "playList.xml";
    public static final String SETTINGS_FILE = "settings.xml";
    public static final String RECENT_PLAYLISTS_FILE = "recentPlayLists.xml";
    public static final int TIMER_INTERVAL = 80;
    public final MouseSleepCounter mouseSleepCounter = new MouseSleepCounter(30);
    public final PointProperty mousePos = new PointProperty("mousePos");
    public static final String TITLE = "Musician's Practicing Player";
    private TableViewer _commandsTable;
    private Track _currentTrack;
    private Float _currentTrackDuration;
    private Frame _frame;
    private MarkersDocument _markers;
    private SettingsDocument _settings;
    private TableViewer _markersTable;
    private PlayListDocument _playList;
    private CLabel _playListLabel;
    private TableViewer _playListTable;
    private Favorites _recentPlayLists;
    private Scale _scale;
    private IPlayer _player;
    private Boolean _activePlayerChanged;
    private Rectangle _lastBounds;

    public static String formatPosition(float position) {
        return MessageFormat.format(FORMAT_MARKER_POSITION, new Float(position));
    }

    public static int indexOfTableItem(Table table, Object itemData) {
        TableItem[] markers = table.getItems();
        int index = -1;
        int i = 0;
        int n = markers.length;
        while (i < n && index == -1) {
            TableItem marker = markers[i];
            if (marker.getData().equals(itemData)) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public static void main(String[] args) {
        Shell shell = null;
        try {
            boolean quit;
            boolean needsRestart;
            Main main = new Main();
            do {
                quit = false;
                shell = new Shell();
                shell.setText(TITLE);
                shell.setImage(Resource.main.createImage());
                shell.setLayout((Layout)new FillLayout());
                Frame frame = new Frame(main, (Composite)shell, 0);
                main.init(frame);
                shell.open();
                SettingsDocument settings = main.getSettings();
                Players players = settings.getPlayers();
                if (players.hasActivePlayer() && frame._player == null) {
                    Player activePlayer = players.getActivePlayer();
                    String text = MessageFormat.format("The Player ''{0}'' could not be embedded.\nYou can now select another.", activePlayer.toExternalPlayer().getTitle());
                    MessageDialog.openError((Shell)shell, (String)TITLE, (String)text);
                    activePlayer.setPlayerActiveState(PlayerActiveState.disabled);
                    activePlayer.setPlayerAvailableState(PlayerAvailableState.notYetDiscovered);
                    main.saveSettings();
                }
                if (!players.hasActivePlayer()) {
                    main.discoverPlayers(true);
                    main.dispose();
                    if (main.getActivePlayerChanged()) {
                        settings = main.getSettings();
                        players = settings.getPlayers();
                    }
                }
                if (!players.hasActivePlayer()) {
                    quit = true;
                }
                boolean bl = needsRestart = main.getActivePlayerChanged() && !quit;
                if (quit || needsRestart) continue;
                Display display = shell.getDisplay();
                while (!shell.isDisposed()) {
                    try {
                        if (display.readAndDispatch()) continue;
                        display.sleep();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                needsRestart = main.getActivePlayerChanged();
            } while (needsRestart && !quit);
        }
        catch (Exception e) {
            MessageDialog.openError(null, (String)TITLE, (String)String.valueOf(e.getMessage()));
            e.printStackTrace();
        }
    }

    protected static String toLocalFileName(String fileName) {
        return new File(fileName).getName();
    }

    public Main() {
        _instance = this;
        Window.setDefaultImage((Image)Resource.main.createImage());
    }

    public Marker getCurrentMarker() {
        Marker result = null;
        if (this.hasCurrentTrack()) {
            String currentFile = Main.toLocalFileName(this.getCurrentTrack().file.get());
            Markers.Iterator markers = this.getMarkers().getMarkers().iterator();
            while (markers.hasNext() && result == null) {
                Marker marker = markers.next();
                if (!marker.getFile().equalsIgnoreCase(currentFile)) continue;
                result = marker;
            }
        }
        return result;
    }

    public Track getCurrentTrack() {
        return this._currentTrack;
    }

    public Float getCurrentTrackDuration() {
        return this._currentTrackDuration;
    }

    public MarkersDocument getMarkers() {
        if (this._markers == null) {
            File f = this.getMarkersFile();
            this._markers = f.exists() ? MarkersDocument.load(f) : MarkersDocument.create();
        }
        return this._markers;
    }

    protected File getSettingsFile() {
        return new File(this.getInstallLocation(), SETTINGS_FILE);
    }

    protected File getMarkersFile() {
        return new File(this.getInstallLocation(), MARKERS_FILE);
    }

    protected File getPlayListFile() {
        return new File(this.getInstallLocation(), PLAYLIST_FILE);
    }

    protected File getRecentPlayListsFile() {
        return new File(this.getInstallLocation(), RECENT_PLAYLISTS_FILE);
    }

    private File getInstallLocation() {
        try {
            return new File(Platform.resolve((URL)MpplayerPlugin.getDefault().getBundle().getEntry("/")).getFile());
        }
        catch (Exception e) {
            throw new MpplayerException(e);
        }
    }

    public void saveSettings() {
        this.getSettings().save(this.getSettingsFile());
    }

    public SettingsDocument getSettings() {
        if (this._settings == null) {
            SettingsDocument settings;
            File f = this.getSettingsFile();
            if (f.exists()) {
                settings = SettingsDocument.load(f);
            } else {
                settings = SettingsDocument.create();
                settings.save(f);
            }
            this._settings = settings;
        }
        return this._settings;
    }

    public void setSettings(SettingsDocument settings) {
        this._settings = settings;
    }

    public PlayListDocument getPlayList() {
        if (this._playList == null) {
            File file = this.getPlayListFile();
            this._playList = file.exists() ? PlayListDocument.load(file) : PlayListDocument.create();
        }
        return this._playList;
    }

    public Favorites getRecentPlayLists() {
        if (this._recentPlayLists == null) {
            Favorites favs = new Favorites(10);
            File file = this.getRecentPlayListsFile();
            if (file.exists()) {
                RecentPlayListsDocument pls = RecentPlayListsDocument.load(file);
                RecentPlayLists.Iterator aPls = pls.recentPlayLists.get().iterator();
                while (aPls.hasNext()) {
                    favs.add((Object)aPls.next().value.get());
                }
            }
            this._recentPlayLists = favs;
        }
        return this._recentPlayLists;
    }

    public boolean hasCurrentTrack() {
        return this.getCurrentTrack() != null;
    }

    public boolean hasCurrentTrackDuration() {
        return this.getCurrentTrackDuration() != null;
    }

    protected void init(Frame frame) {
        this._frame = frame;
        frame.getShell().setBounds(this.getLastBounds());
        Command.choosePlayer.getTool().setImage(ExternalPlayer.getImageDiscover());
        this.setActivePlayerChanged(false);
        this._player = frame._player;
        if (this._player != null) {
            this._player.addPlayerListener(new IPlayerListener(){

                public void onMediaEnded() {
                    Main.this.onPlayerMediaEnded();
                }
            });
        }
        this._commandsTable = frame._commandsTable;
        this._commandsTable.setLabelProvider((IBaseLabelProvider)new CommandsTableLabelProvider());
        this._commandsTable.setContentProvider((IContentProvider)new CommandsTableContentProvider());
        this._commandsTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                Main.this.onCommandsTableDoubleClick();
            }
        });
        Table aCommandsTable = this._commandsTable.getTable();
        aCommandsTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                Main.this.onCommandsTableKeyPressed(e);
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        aCommandsTable.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent arg0) {
                Main.this.onCommandsTableMouseEnter();
            }

            public void mouseExit(MouseEvent arg0) {
            }

            public void mouseHover(MouseEvent arg0) {
            }
        });
        this._markersTable = frame._markersTable;
        this._scale = frame._scale;
        this._scale.setContentProvider(new ScaleContentProvider());
        this._scale.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object obj) {
                return obj.equals(Scale.SELECTION) ? Main.formatPosition(Main.this._player.getPlayPosition()) : String.valueOf(((MarkerPosition)obj).getIndex() + 1);
            }
        });
        this._scale.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                Main.this.onScaleSelected(e.detail == 1, (Integer)e.data);
            }
        });
        this._playListLabel = frame._playListLabel;
        this._playListTable = frame._playListTable;
        this._markersTable.setLabelProvider((IBaseLabelProvider)new MarkersTableLabelProvider());
        this._markersTable.setContentProvider((IContentProvider)new MarkersTableContentProvider());
        this._markersTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                Main.this.onMarkersTableDoubleClick();
            }
        });
        this._playListTable.setLabelProvider((IBaseLabelProvider)new PlayListTableLabelProvider());
        this._playListTable.setContentProvider((IContentProvider)new PlayListTableContentProvider());
        this._playListTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                Main.this.onPlayListTableDoubleClick();
            }
        });
        Command.setListener(this);
        Command.addMarker.setKeyInfo('a', "Add a Marker at the current Position");
        Command.removeMarker.setKeyInfo('r', "Remove the selected Marker");
        Command.removeAllMarkers.setKeyInfo('g', "Remove all Markers");
        Command.play.setKeyInfo(' ', "Play / Pause");
        Command.stop.setKeyInfo('t', "Stop");
        Command.home.setKeyInfo('h', "Home");
        Command.back.setKeyInfo('o', "Seek Back");
        Command.forward.setKeyInfo('p', "Seek Forward");
        Command.previousMarker.setKeyInfo('k', "Previous Marker");
        Command.nextMarker.setKeyInfo('l', "Next Marker");
        Command.previousTrack.setKeyInfo('n', "Previous Track");
        Command.nextTrack.setKeyInfo('m', "Next Track");
        Command.backToLastMarker.setKeyInfo('b', "Back to Last Marker");
        Command.jumpToMarker.setKeyInfo('\u0000', "Jumps to the Marker Number 1-10");
        Command.playListOpen.setKeyInfo('y', "Opens a Play List");
        Command.playListSaveAs.setKeyInfo('s', "Saves the Play List in a File");
        Command.playListAddTracks.setKeyInfo('e', "Adds more Tracks to the Play List");
        Command.playListRemoveTracks.setKeyInfo('v', "Removes the selected Tracks from the Play List");
        Command.playListRemoveAllTracks.setKeyInfo('z', "Removes all Tracks from the Play List");
        Command.quit.setKeyInfo('x', "Exits the Application");
        Command.choosePlayer.setKeyInfo('c', "Show Player Information");
        Command.autoCommandFocus.setKeyInfo('f', "Enable / Disable Auto-Command Focus");
        Command.joystickSettings.setKeyInfo('w', "Change Joystick Settings");
        Command.about.setKeyInfo('u', "Show Information about Musician's Practicing Player");
        final Display display = frame.getDisplay();
        Runnable timer = new Runnable(){

            public void run() {
                try {
                    Main.this.onTimer();
                }
                catch (RuntimeException runtimeException) {}
                display.timerExec(80, (Runnable)this);
            }
        };
        display.timerExec(80, timer);
        this.initDnD();
        MyJoystick joy = this.getJoy();
        joy.install(this._frame);
        joy.setEnabled(this.getSettings().getJoystickEnabled());
        this.setPlayList(this.getPlayList(), false);
        this._commandsTable.setInput(new Object());
    }

    public void discoverPlayers(boolean autoDiscover) {
        final SettingsDocument settingsClone = new SettingsDocument((XmlNode)this.getSettings().getDelegate().clone());
        PlayerSelectionWizard wizard = new PlayerSelectionWizard(settingsClone){

            public boolean performFinish() {
                settingsClone.getPlayers().setActivePlayer(this.getPage().getSelectedPlayer());
                return true;
            }

            public void doFinish(IProgressMonitor monitor) {
            }
        };
        final XWizardDialog dlg = new XWizardDialog(this._frame.getShell(), (IWizard)wizard);
        final Players players = settingsClone.getPlayers();
        final Player activePlayer = players.getActivePlayer();
        dlg.create();
        if (autoDiscover) {
            wizard.getPage().onDiscover();
        }
        this.invokeDialog(new Runnable(){

            public void run() {
                Player newActivePlayer;
                if (dlg.open() == 0 && !(newActivePlayer = players.getActivePlayer()).equals(activePlayer)) {
                    Main.this.setSettings(settingsClone);
                    Main.this.saveSettings();
                    Main.this.setActivePlayerChanged();
                }
            }
        });
    }

    protected void initDnD() {
        Transfer[] types = new Transfer[]{FileTransfer.getInstance()};
        int operations = 1;
        Shell shell = this._frame.getShell();
        DropTarget target = new DropTarget((Control)shell, operations);
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                Main.this.onDragEnter(event);
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                Main.this.onDragOver(event);
            }

            public void drop(DropTargetEvent event) {
                Main.this.onDrop(event);
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    public boolean isActive() {
        PlayState playState = this._player.getPlayState();
        return this.hasCurrentTrack() && (playState.isPlaying() || playState.isPaused());
    }

    public boolean isMarkersTableEmpty() {
        return this._markersTable.getTable().getItemCount() == 0;
    }

    public boolean isPlayListTableEmpty() {
        return this._playListTable.getTable().getItemCount() == 0;
    }

    protected void onCommandsTableDoubleClick() {
        Command cmd = (Command)this._commandsTable.getTable().getSelection()[0].getData();
        cmd.invoke(false);
    }

    protected void onCommandsTableKeyPressed(KeyEvent e) {
        char c = e.character;
        if (c >= '0' && c <= '9') {
            int marker = c == '0' ? 10 : Integer.parseInt(String.valueOf(c));
            Table markerTable = this._markersTable.getTable();
            TableItem[] markers = markerTable.getItems();
            if (--marker < markers.length) {
                markerTable.setSelection(marker);
                this.onMarkersTableDoubleClick();
            }
        } else {
            if (c == '\b') {
                c = 'b';
            }
            char aC = c;
            Command cmd = null;
            Iterator all = Command.getAll().iterator();
            while (all.hasNext() && cmd == null) {
                Command aCmd = (Command)all.next();
                if (aCmd.getKey() != aC || aCmd.isJumpToMarker()) continue;
                cmd = aCmd;
            }
            if (cmd == null) {
                if (c == ' ') {
                    cmd = Command.play;
                } else if (e.keyCode == 0x1000007) {
                    cmd = Command.home;
                }
            }
            if (cmd != null) {
                cmd.invoke(false);
                Table commandsTable = this._commandsTable.getTable();
                TableItem[] cmds = commandsTable.getItems();
                int index = -1;
                int i = 0;
                int n = cmds.length;
                while (i < n && index == -1) {
                    TableItem cmdItem = cmds[i];
                    if (cmdItem.getData().equals(cmd)) {
                        index = i;
                    }
                    ++i;
                }
                commandsTable.select(index);
                commandsTable.showSelection();
            }
        }
    }

    protected void onCommandsTableMouseEnter() {
        this._frame._commandsMarkersViewForm.setFocus();
    }

    protected void onDragEnter(DropTargetEvent event) {
    }

    protected void onDragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    protected void onDrop(DropTargetEvent event) {
        PlayListDocument playList = PlayListDocument.create();
        String[] fileNames = (String[])event.data;
        int i = 0;
        while (i < fileNames.length) {
            String fileName = fileNames[i];
            File file = new File(fileName);
            PlayListReader reader = PlayListReader.parse(file);
            if (reader == null) {
                Track newTrack = playList.addTrack();
                newTrack.title.set(Main.toLocalFileName(fileName));
                newTrack.file.set(fileName);
            } else {
                try {
                    reader.read(playList, file);
                }
                catch (Exception e) {
                    String text = MessageFormat.format("An error occured while reading the {0} Play List.\n\nThe system says: {1}", reader.getTitle(), String.valueOf(e.getMessage()));
                    MessageDialog.openError((Shell)this._frame.getShell(), (String)TITLE, (String)text);
                }
            }
            ++i;
        }
        this.setPlayList(playList, true);
    }

    protected void onJoystick(JoystickDirection dir) {
        SettingsDocument settings = this.getSettings();
        Command cmd = dir.isRight() ? settings.getJoystickRightCommand() : (dir.isLeft() ? settings.getJoystickLeftCommand() : (dir.isUp() ? settings.getJoystickUpCommand() : settings.getJoystickDownCommand()));
        cmd.invoke(false);
    }

    protected void onMarkersTableDoubleClick() {
        try {
            TableItem[] selection = this._markersTable.getTable().getSelection();
            if (selection.length > 0) {
                MarkerPosition position = (MarkerPosition)selection[0].getData();
                this._player.setCurrentPlayPosition(position.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onPlayListTableDoubleClick() {
        this._frame.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!Main.this._player.getPlayState().isStopped()) {
                    Main.this.onToolStop();
                }
                Main.this.onToolPlay();
            }
        });
    }

    protected void onPrevNextMarker(boolean prev) {
        int newSel;
        Table markerList = this._markersTable.getTable();
        int itemCount = markerList.getItemCount();
        int sel = markerList.getSelectionIndex();
        if (prev) {
            newSel = sel - 1;
            if (newSel < 0) {
                newSel = itemCount - 1;
            }
        } else {
            newSel = sel + 1;
            if (newSel == itemCount) {
                newSel = 0;
            }
        }
        markerList.select(newSel);
        markerList.showSelection();
        this.onMarkersTableDoubleClick();
    }

    protected void onPrevNextTrack(Command previousOrNextTrack) {
        int newSel;
        Table playList = this._playListTable.getTable();
        int itemCount = playList.getItemCount();
        int sel = playList.getSelectionIndex();
        if (previousOrNextTrack.isPreviousTrack()) {
            newSel = sel - 1;
            if (newSel < 0) {
                newSel = itemCount - 1;
            }
        } else {
            newSel = sel + 1;
            if (newSel == itemCount) {
                newSel = 0;
            }
        }
        playList.deselectAll();
        playList.select(newSel);
        playList.showSelection();
        this.onPlayListTableDoubleClick();
    }

    protected void onRecentPlayListSelected(SelectionEvent e) {
        MenuItem menu = (MenuItem)e.widget;
        Favorites pls = this.getRecentPlayLists();
        String pl = (String)pls.get(((Integer)menu.getData()).intValue());
        this.openPlayList(pl);
    }

    protected void onScaleSelected(boolean onScale, int selection) {
        if (this.isActive()) {
            if (onScale) {
                int marker = this._scale.markerAtSelection(selection);
                if (marker != -1) {
                    MarkerPosition m = (MarkerPosition)this._markersTable.getTable().getItem(marker).getData();
                    this._player.setCurrentPlayPosition(m.getValue());
                } else {
                    this.addMarker(selection);
                }
            } else {
                this._player.setCurrentPlayPosition(this._scale.getSelection());
            }
        }
    }

    protected void onTimer() {
        Point p = this._frame.getShell().getDisplay().getCursorLocation();
        this.mouseSleepCounter.next();
        if (this.getSettings().getAutoCommandFocus() && this.mouseSleepCounter.isReached()) {
            if (p.equals((Object)this.mousePos.get())) {
                this._frame.getShell().setActive();
                this._frame._commandsMarkersViewForm.setFocus();
            }
            this.mouseSleepCounter.unset();
        }
        this.mousePos.set(p);
        Command.updateAllToolsUI();
        PlayState playState = this._player.getPlayState();
        if (playState.isPlaying()) {
            if (!this.hasCurrentTrackDuration()) {
                Float duration = new Float(this._player.getCurrentMediaDuration());
                this.setCurrentTrackDuration(duration);
                this._scale.setMax((int)duration.floatValue());
            }
            float position = this._player.getPlayPosition();
            if ((float)this._scale.getSelection() != position) {
                this._scale.setSelection((int)position);
                this._frame._playControlsLabel.setText(Main.formatPosition(position));
            }
            TableItem[] items = this._markersTable.getTable().getItems();
            int i = 0;
            int n = items.length;
            while (i < n) {
                float qPos = position + 0.4f;
                TableItem item = items[i];
                float markerPos = ((MarkerPosition)item.getData()).getValue();
                if (qPos < markerPos) break;
                ++i;
            }
            this._markersTable.getTable().select(Math.max(i - 1, 0));
        } else if (!this._player.getPlayState().isPaused() && this._scale.getSelection() != 0) {
            this._scale.setSelection(0);
        }
        this.updatePlayControlsState();
    }

    public void dispose() {
        this.setLastBounds(this._frame.getShell().getBounds());
        this._frame.getShell().dispose();
    }

    public void onToolQuit() {
        this.dispose();
    }

    public void onToolAbout() {
        final AboutDialog dialog = new AboutDialog(this._frame.getShell());
        this.invokeDialog(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public void onToolJoystickSettings() {
        final SettingsDocument settingsClone = new SettingsDocument((XmlNode)this.getSettings().getDelegate().clone());
        SettingsWizard wizard = new SettingsWizard(settingsClone);
        final XWizardDialog dlg = new XWizardDialog(this._frame.getShell(), (IWizard)wizard);
        this.invokeDialog(new Runnable(){

            public void run() {
                if (dlg.open() == 0) {
                    Main.this.setSettings(settingsClone);
                    Main.this.getJoy().setEnabled(settingsClone.getJoystickEnabled());
                    Main.this.saveSettings();
                }
            }
        });
    }

    public void addMarker(float position) {
        boolean refreshOnly;
        MarkersDocument markers = this.getMarkers();
        Marker marker = this.getCurrentMarker();
        if (marker == null) {
            marker = markers.addMarker();
            marker.setFile(Main.toLocalFileName(this.getCurrentTrack().file.get()));
            refreshOnly = false;
        } else {
            refreshOnly = true;
        }
        marker.addPosition().setValue(position);
        if (refreshOnly) {
            this._markersTable.refresh();
            this._scale.refresh();
        } else {
            this.setMarkerViewersInput();
        }
        this.saveMarkers();
    }

    public void onToolAddMarker() {
        this.addMarker(this._player.getPlayPosition());
    }

    public void onToolBack() {
        this.onToolBackForward(Command.back);
    }

    public void onUpdateToolUIChoosePlayer(UpdateCmdUi cmdUI) {
        Players players = this.getSettings().getPlayers();
        Image image = players.hasActivePlayer() ? players.getActivePlayer().toExternalPlayer().getImage() : ExternalPlayer.getImageDiscover();
        cmdUI.setImage(image);
    }

    public void onUpdateToolUIAutoCommandFocus(UpdateCmdUi cmdUI) {
        cmdUI.setChecked(this.getSettings().getAutoCommandFocus());
    }

    public void onToolAutoCommandFocus() {
        SettingsDocument settings;
        settings.setAutoCommandFocus(!(settings = this.getSettings()).getAutoCommandFocus());
        this.saveSettings();
    }

    public void onToolChoosePlayer() {
        this.discoverPlayers(false);
        if (this.getActivePlayerChanged()) {
            this.dispose();
        }
    }

    public void onToolDropDownChoosePlayer() {
        Menu menu = new Menu((Decorations)this._frame.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("&Select / Discover Player...");
        item.setImage(ExternalPlayer.getImageDiscover());
        item.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                Main.this.onToolChoosePlayer();
            }
        });
        new MenuItem(menu, 2);
        Players aplayers = this.getSettings().getPlayers();
        Player activePlayer = aplayers.getActivePlayer();
        Players.Iterator players = aplayers.iterator();
        while (players.hasNext()) {
            final Player player = players.next();
            item = new MenuItem(menu, 32);
            item.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent e) {
                    Main.this.onPlayerSelected(player);
                }
            });
            ExternalPlayer exPlayer = player.toExternalPlayer();
            item.setText("&" + exPlayer.getTitle());
            item.setImage(exPlayer.getImage());
            item.setEnabled(player.getPlayerAvailableState().isAvailable());
            item.setSelection(player.equals(activePlayer));
        }
        menu.setLocation(this.getToolMenuPosition(Command.choosePlayer.getTool()));
        menu.setVisible(true);
    }

    protected void onPlayerSelected(Player player) {
        Players players = this.getSettings().getPlayers();
        if (!player.equals(players.getActivePlayer())) {
            players.setActivePlayer(player);
            this.saveSettings();
            this.setActivePlayerChanged();
            this.dispose();
        }
    }

    protected void onToolBackForward(Command backOrForward) {
        float offset = 0.5f;
        if (backOrForward.isBack()) {
            offset *= -1.0f;
        }
        this._player.setCurrentPlayPosition(this._player.getPlayPosition() + offset);
    }

    public void onToolBackToLastMarker() {
        float posNow;
        boolean dejaVu;
        float pos = ((MarkerPosition)this._markersTable.getTable().getSelection()[0].getData()).getValue();
        boolean bl = dejaVu = (int)pos == (int)(posNow = this._player.getPlayPosition());
        if (dejaVu) {
            this.onToolPreviousMarker();
        } else {
            this._player.setCurrentPlayPosition(pos);
        }
    }

    public void onToolDropDownPlayListOpen() {
        Menu menu = new Menu((Decorations)this._frame.getShell(), 8);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("&Open...");
        item.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent e) {
                Main.this.onToolPlayListOpen();
            }
        });
        new MenuItem(menu, 2);
        Favorites pls = this.getRecentPlayLists();
        int n = pls.size();
        if (n > 0) {
            int i = 0;
            while (i < n) {
                String pl = (String)pls.get(i);
                item = new MenuItem(menu, 8);
                item.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent arg0) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Main.this.onRecentPlayListSelected(e);
                    }
                });
                int nr = i + 1;
                String aNr = nr == 10 ? "1&0" : "&" + String.valueOf(nr);
                item.setText(MessageFormat.format("{0} - {1}", aNr, pl));
                item.setData((Object)new Integer(i));
                ++i;
            }
        } else {
            item = new MenuItem(menu, 8);
            item.setText("<Recently Opened Play List>");
            item.setEnabled(false);
        }
        menu.setLocation(this.getToolMenuPosition(Command.playListOpen.getTool()));
        menu.setVisible(true);
    }

    protected Point getToolMenuPosition(ToolItem tool) {
        Rectangle bounds = tool.getBounds();
        return tool.getParent().toDisplay(bounds.x, bounds.y + bounds.height);
    }

    public void onToolForward() {
        this.onToolBackForward(Command.forward);
    }

    public void onToolHome() {
        this._player.setCurrentPlayPosition(0.0f);
    }

    public void onToolNextMarker() {
        this.onPrevNextMarker(false);
    }

    public void onToolNextTrack() {
        this.onPrevNextTrack(Command.nextTrack);
    }

    public void onToolPlay() {
        try {
            PlayState playState = this._player.getPlayState();
            if (playState.isPlaying()) {
                this._player.pause();
            } else if (playState.isPaused()) {
                this._player.play();
            } else {
                Track track;
                Table playList = this._playListTable.getTable();
                TableItem[] sel = playList.getSelection();
                if (sel.length == 0) {
                    track = (Track)playList.getItem(0).getData();
                    playList.select(0);
                } else {
                    track = (Track)sel[0].getData();
                }
                this.unsetCurrentTrackDuration();
                String trackFile = track.file.get();
                if (new File(trackFile).exists()) {
                    this._player.load(trackFile);
                    this._scale.setMax((int)this._player.getCurrentMediaDuration());
                    this.setCurrentTrack(track);
                    this.setMarkerViewersInput();
                } else {
                    String text = MessageFormat.format("The file ''{0}'' does not exist.", trackFile);
                    MessageDialog.openError((Shell)this._frame.getShell(), (String)TITLE, (String)text);
                }
            }
        }
        catch (Exception e) {
            String text = MessageFormat.format("An error occured while playing.\n\nThe system says: {0}", String.valueOf(e.getMessage()));
            MessageDialog.openError((Shell)this._frame.getShell(), (String)TITLE, (String)text);
        }
    }

    public void setMarkerViewersInput() {
        Marker currentMarker = this.getCurrentMarker();
        this._markersTable.setInput((Object)this.getCurrentMarker());
        this._scale.setInput(currentMarker);
    }

    public void onToolPlayListAddTracks() {
        final FileDialog dlg = new FileDialog(this._frame.getShell(), 4098);
        dlg.setFilterExtensions(new String[]{"*.*"});
        dlg.setFilterNames(new String[]{"All Files (*.*)"});
        this.invokeDialog(new Runnable(){

            public void run() {
                dlg.open();
            }
        });
        String[] files = dlg.getFileNames();
        String path = XString.ensureEndsWith((String)dlg.getFilterPath(), (String)"/");
        if (files != null) {
            PlayListDocument playList = this.getPlayList();
            int n = files.length;
            Object[] newTracks = new Track[n];
            int i = 0;
            while (i < n) {
                String file = String.valueOf(path) + files[i];
                Track track = playList.addTrack();
                track.title.set(Main.toLocalFileName(file));
                track.file.set(file);
                newTracks[i] = track;
                ++i;
            }
            this._playListTable.refresh();
            this._playListTable.setSelection((ISelection)new StructuredSelection(newTracks), true);
            this.savePlayList();
        }
    }

    public void onToolPlayListOpen() {
        final FileDialog dlg = new FileDialog(this._frame.getShell(), 4096);
        List readers = PlayListReader.getAll();
        int readersSize = readers.size();
        String[] exts = new String[readersSize];
        String[] names = new String[readersSize];
        int i = 0;
        while (i < readersSize) {
            PlayListReader reader = (PlayListReader)readers.get(i);
            exts[i] = reader.getFilter();
            names[i] = reader.getFilterName();
            ++i;
        }
        dlg.setFilterExtensions(exts);
        dlg.setFilterNames(names);
        this.invokeDialog(new Runnable(){

            public void run() {
                String file = dlg.open();
                if (file != null) {
                    Main.this.openPlayList(file);
                }
            }
        });
    }

    public void onToolPlayListRemoveAllTracks() {
        Tracks.Iterator tracks = this.getPlayList().tracks.get().iterator();
        while (tracks.hasNext()) {
            tracks.next().remove();
        }
        this._playListTable.refresh();
        this.savePlayList();
    }

    public void onToolPlayListRemoveTracks() {
        Table playList = this._playListTable.getTable();
        TableItem[] selItems = playList.getSelection();
        HashSet<TableItem> aSelItems = new HashSet<TableItem>();
        int i = 0;
        int n = selItems.length;
        while (i < n) {
            aSelItems.add(selItems[i]);
            ++i;
        }
        TableItem[] items = playList.getItems();
        int lastSel = -1;
        int i2 = 0;
        int n2 = items.length;
        while (i2 < n2) {
            TableItem item = items[i2];
            if (aSelItems.contains(item)) {
                ((Track)item.getData()).remove();
                lastSel = i2;
            }
            ++i2;
        }
        this._playListTable.refresh();
        int itemCount = playList.getItemCount();
        if (lastSel >= itemCount) {
            lastSel = itemCount - 1;
        }
        playList.select(lastSel);
        this.savePlayList();
    }

    public void onToolPlayListSaveAs() {
        final FileDialog dlg = new FileDialog(this._frame.getShell(), 8192);
        final PlayListReader mpppReader = PlayListReader.mppp;
        dlg.setFilterExtensions(new String[]{mpppReader.getFilter()});
        dlg.setFilterNames(new String[]{mpppReader.getFilterName()});
        dlg.setFileName("Untitled." + mpppReader.getName());
        this.invokeDialog(new Runnable(){

            public void run() {
                String file = dlg.open();
                if (file != null) {
                    boolean doIt;
                    File aFile;
                    String ext = mpppReader.getExtension();
                    if (!file.endsWith(ext)) {
                        file = String.valueOf(file) + ext;
                    }
                    if ((aFile = new File(file)).exists()) {
                        String question = MessageFormat.format("The File ''{0}'' already exists. Overwrite?", file);
                        doIt = MessageDialog.openQuestion((Shell)Main.this._frame.getShell(), (String)Main.TITLE, (String)question);
                    } else {
                        doIt = true;
                    }
                    if (doIt) {
                        try {
                            Main.this.getPlayList().save(aFile);
                            Main.this.getRecentPlayLists().add((Object)file);
                            Main.this.saveRecentPlayLists();
                        }
                        catch (Exception e) {
                            String text = MessageFormat.format("An error occured while saving the Play List to ''{0}''.\n\nThe system says: {1}", file, String.valueOf(e.getMessage()));
                            MessageDialog.openError((Shell)Main.this._frame.getShell(), (String)Main.TITLE, (String)text);
                        }
                    }
                }
            }
        });
    }

    public void onToolPreviousMarker() {
        this.onPrevNextMarker(true);
    }

    public void onToolPreviousTrack() {
        this.onPrevNextTrack(Command.previousTrack);
    }

    public void onToolRemoveAllMarkers() {
        Marker marker = this.getCurrentMarker();
        MarkerPositions.Iterator poss = marker.getPositions().iterator();
        while (poss.hasNext()) {
            poss.next().remove();
        }
        this._markersTable.refresh();
        this.saveMarkers();
    }

    public void onToolRemoveMarker() {
        Table markerList = this._markersTable.getTable();
        TableItem[] selItems = markerList.getSelection();
        HashSet<TableItem> aSelItems = new HashSet<TableItem>();
        int i = 0;
        int n = selItems.length;
        while (i < n) {
            aSelItems.add(selItems[i]);
            ++i;
        }
        TableItem[] items = markerList.getItems();
        int lastSel = -1;
        int i2 = 0;
        int n2 = items.length;
        while (i2 < n2) {
            TableItem item = items[i2];
            if (aSelItems.contains(item)) {
                ((MarkerPosition)item.getData()).remove();
                lastSel = i2;
            }
            ++i2;
        }
        this._markersTable.refresh();
        this._scale.refresh();
        int itemCount = markerList.getItemCount();
        if (lastSel >= itemCount) {
            lastSel = itemCount - 1;
        }
        markerList.select(lastSel);
        this.saveMarkers();
    }

    public void onToolStop() {
        this._player.stop();
        this.unsetCurrentTrack();
        this._frame._playControlsLabel.setText(Message.getString("Frame.playControlsLabel.text"));
        this._markersTable.setInput(null);
    }

    public void onUpdateToolUIAddMarker(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(this.isActive());
    }

    public void onUpdateToolUIBack(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(this.isActive());
    }

    public void onUpdateToolUIBackToLastMarker(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isMarkersTableEmpty() && this.isActive());
    }

    public void onUpdateToolUIForward(UpdateCmdUi cmdUI) {
        this.onUpdateToolUIBack(cmdUI);
    }

    public void onUpdateToolUIHome(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(this.isActive());
    }

    public void onUpdateToolUINextMarker(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(this._markersTable.getTable().getItemCount() > 1);
    }

    public void onUpdateToolUINextTrack(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isPlayListTableEmpty());
    }

    public void onUpdateToolUIPlay(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isPlayListTableEmpty());
        Command.Play play = Command.play;
        cmdUI.setImage(this._player.getPlayState().isPlaying() ? play.getImage2() : play.getImage());
    }

    public void onUpdateToolUIPlayListRemoveAllTracks(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isPlayListTableEmpty());
    }

    public void onUpdateToolUIPlayListRemoveTracks(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(this._playListTable.getTable().getSelectionCount() > 0);
    }

    public void onUpdateToolUIPlayListSaveAs(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isPlayListTableEmpty());
    }

    public void onUpdateToolUIPreviousMarker(UpdateCmdUi cmdUI) {
        this.onUpdateToolUINextMarker(cmdUI);
    }

    public void onUpdateToolUIPreviousTrack(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isPlayListTableEmpty());
    }

    public void onUpdateToolUIRemoveAllMarkers(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!this.isMarkersTableEmpty());
    }

    public void onUpdateToolUIRemoveMarker(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(!((IStructuredSelection)this._markersTable.getSelection()).isEmpty());
    }

    public void onUpdateToolUIStop(UpdateCmdUi cmdUI) {
        cmdUI.setEnabled(this.isActive());
    }

    protected void onPlayerMediaEnded() {
        this.onToolNextTrack();
    }

    protected void openPlayList(final String fileName) {
        final File file = new File(fileName);
        final PlayListReader reader = PlayListReader.parse(file);
        if (reader != null) {
            try {
                BusyIndicator.showWhile((Display)this._frame.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        Main.this.setPlayList(reader.create(file), true);
                        Main.this.getRecentPlayLists().add((Object)fileName);
                        Main.this.saveRecentPlayLists();
                    }
                });
            }
            catch (Exception e) {
                String text = MessageFormat.format("An error occured while reading the {0} Play List.\n\nThe system says: {1}", reader.getTitle(), String.valueOf(e.getMessage()));
                MessageDialog.openError((Shell)this._frame.getShell(), (String)TITLE, (String)text);
            }
        } else {
            String text = MessageFormat.format("The File {0} has an unknown Format. It cannot be opened.", fileName);
            MessageDialog.openError((Shell)this._frame.getShell(), (String)TITLE, (String)text);
        }
    }

    protected void saveMarkers() {
        this.getMarkers().save(this.getMarkersFile());
    }

    protected void savePlayList() {
        this.getPlayList().save(this.getPlayListFile());
    }

    protected void saveRecentPlayLists() {
        RecentPlayListsDocument doc = RecentPlayListsDocument.create();
        Iterator pls = this.getRecentPlayLists().iterator();
        while (pls.hasNext()) {
            String pl = (String)pls.next();
            doc.addRecentPlayList().value.set(pl);
        }
        doc.save(this.getRecentPlayListsFile());
    }

    protected void setCurrentTrack(Track currentTrack) {
        this._currentTrack = currentTrack;
    }

    protected void setCurrentTrackDuration(Float currentTrackDuration) {
        this._currentTrackDuration = currentTrackDuration;
    }

    protected void setPlayList(PlayListDocument playList, boolean save) {
        this._playList = playList;
        this._playListTable.setInput((Object)playList);
        Table aPlayList = this._playListTable.getTable();
        if (aPlayList.getItemCount() > 0) {
            aPlayList.select(0);
        }
        if (save) {
            this.savePlayList();
        }
    }

    public void unsetCurrentTrack() {
        this.setCurrentTrack(null);
    }

    public void unsetCurrentTrackDuration() {
        this.setCurrentTrackDuration(null);
    }

    protected void updatePlayControlsState() {
        String text;
        String string = text = this.isActive() ? "Now Playing: " + this.getCurrentTrack().title.get() : "Play List";
        if (!this._playListLabel.getText().equals(text)) {
            this._playListLabel.setText(text);
        }
    }

    public boolean getActivePlayerChanged() {
        if (this._activePlayerChanged == null) {
            this._activePlayerChanged = Boolean.FALSE;
        }
        return this._activePlayerChanged;
    }

    protected void setActivePlayerChanged(boolean activePlayerChanged) {
        this._activePlayerChanged = activePlayerChanged;
    }

    protected void setActivePlayerChanged() {
        this.setActivePlayerChanged(true);
    }

    public Rectangle getLastBounds() {
        if (this._lastBounds == null) {
            Rectangle bounds = this._frame.getShell().getBounds();
            this._lastBounds = new Rectangle(bounds.x, bounds.y, 650, 700);
        }
        return this._lastBounds;
    }

    public boolean hasLastBounds() {
        return this.getLastBounds() != null;
    }

    protected void setLastBounds(Rectangle lastBounds) {
        this._lastBounds = lastBounds;
    }

    public void unsetLastBounds() {
        this.setLastBounds(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeDialog(Runnable runnable) {
        SettingsDocument settings = this.getSettings();
        boolean prevAutoCommandFocus = settings.getAutoCommandFocus();
        MyJoystick joy = this.getJoy();
        boolean prevJoyEnabled = joy.getEnabled();
        try {
            if (prevAutoCommandFocus) {
                settings.setAutoCommandFocus(false);
            }
            if (prevJoyEnabled) {
                joy.setEnabled(false);
            }
            runnable.run();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (prevAutoCommandFocus) {
                settings.setAutoCommandFocus(true);
            }
            if (!prevJoyEnabled) throw throwable;
            joy.setEnabled(true);
            throw throwable;
        }
        {
            Object var6_8 = null;
            if (prevAutoCommandFocus) {
                settings.setAutoCommandFocus(true);
            }
            if (!prevJoyEnabled) return;
            joy.setEnabled(true);
            return;
        }
    }

    public static Main getInstance() {
        return _instance;
    }

    public MyJoystick getJoy() {
        if (this._joy == null) {
            SettingsDocument settings = this.getSettings();
            this._joy = new MyJoystick(settings.getJoystickInterval(), settings.getJoystickSpeed()){

                public void onJoystick(JoystickDirection direction) {
                    Main.this.onJoystick(direction);
                }
            };
        }
        return this._joy;
    }

    public void setJoy(MyJoystick joy) {
        this._joy = joy;
    }
}

