/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import com.centralnexus.input.Joystick;
import com.centralnexus.input.JoystickListener;
import mpplayer.JoystickDirection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class MyJoystick {
    private int _interval;
    private int _speed;
    private String _lastError;
    private boolean _enabled;
    private Joystick _joy;
    private boolean _discovered;

    public Joystick getJoy() {
        if (!this.getDiscovered()) {
            Joystick joy = null;
            try {
                joy = Joystick.createInstance();
            }
            catch (Throwable t) {
                this.setLastError(String.valueOf(t));
            }
            this.setDiscovered(true);
            this._joy = joy;
        }
        return this._joy;
    }

    public static int joyToSpeed(float joy) {
        return -((int)(joy * 10.0f));
    }

    public MyJoystick(int interval, int speed) {
        this.setInterval(interval);
        this.setSpeed(speed);
        this.getJoy();
    }

    protected int[] getJoySpeed() {
        Joystick joy = this.getJoy();
        return new int[]{MyJoystick.joyToSpeed(-joy.getX()), MyJoystick.joyToSpeed(joy.getY())};
    }

    public boolean isAvailable() {
        return this.getJoy() != null;
    }

    public void install(Composite composite) {
        if (this.isAvailable()) {
            Joystick joy = this.getJoy();
            joy.setPollInterval(80);
            final JoystickListener joyListener = new JoystickListener(){

                public void joystickAxisChanged(Joystick j) {
                }

                public void joystickButtonChanged(Joystick j) {
                }
            };
            joy.addJoystickListener(joyListener);
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    MyJoystick.this.getJoy().removeJoystickListener(joyListener);
                }
            });
            final Display display = composite.getDisplay();
            Runnable joyTimer = new Runnable(){

                public void run() {
                    try {
                        MyJoystick.this.onJoyTimer();
                    }
                    catch (RuntimeException runtimeException) {}
                    display.timerExec(MyJoystick.this.getInterval(), (Runnable)this);
                }
            };
            display.timerExec(this.getInterval(), joyTimer);
        }
    }

    protected void onJoyTimer() {
        if (!this.getEnabled()) {
            return;
        }
        int[] speed = this.getJoySpeed();
        int speedX = speed[0];
        int speedY = speed[1];
        JoystickDirection dir = null;
        int off = this.getSpeed();
        if (off > 1) {
            --off;
        }
        if (speedX > off) {
            dir = JoystickDirection.right;
        } else if (speedX < -off) {
            dir = JoystickDirection.left;
        } else if (speedY > off) {
            dir = JoystickDirection.up;
        } else if (speedY < -off) {
            dir = JoystickDirection.down;
        }
        if (dir != null) {
            this.onJoystick(dir);
        }
    }

    public abstract void onJoystick(JoystickDirection var1);

    public int getInterval() {
        return this._interval;
    }

    protected void setInterval(int interval) {
        this._interval = interval;
    }

    public int getSpeed() {
        return this._speed;
    }

    protected void setSpeed(int speed) {
        this._speed = speed;
    }

    public String getLastError() {
        if (this._lastError == null) {
            this._lastError = "";
        }
        return this._lastError;
    }

    protected void setLastError(String lastError) {
        this._lastError = lastError;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.isAvailable()) {
            this._enabled = enabled;
        }
    }

    protected boolean getDiscovered() {
        return this._discovered;
    }

    protected void setDiscovered(boolean discovered) {
        this._discovered = discovered;
    }
}

