/*
 * Decompiled with CFR 0.152.
 */
package mpplayer;

import com.o3tt3rli.eclipse.ui.frame.WizardPageMainFrame;
import com.o3tt3rli.eclipse.ui.model.ModelWizardPage;
import mpplayer.ExternalPlayer;
import mpplayer.ExternalPlayerContentProvider;
import mpplayer.ExternalPlayerLabelProvider;
import mpplayer.IPlayer;
import mpplayer.Main;
import mpplayer.PlayerSelectionWizard;
import mpplayer.model.Player;
import mpplayer.model.PlayerAvailableState;
import mpplayer.model.Players;
import mpplayer.model.SettingsDocument;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PlayerSelectionWizardPage
extends ModelWizardPage {
    private Composite _playerFrame;
    public TableViewer _playersTable;
    static /* synthetic */ Class class$0;

    public PlayerSelectionWizardPage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mpplayer.PlayerSelectionWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.setTitle("Embedded Player");
        this.setDescription("Select the Embedded Player you wish to use");
    }

    public void createControl(Composite parent) {
        WizardPageMainFrame main = new WizardPageMainFrame(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)main, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText("&Player");
        label.setLayoutData((Object)new GridData(512));
        TableViewer tableViewer = new TableViewer(composite, 67584);
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                PlayerSelectionWizardPage.this.onPlayersTableDoubleClick();
            }
        });
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                PlayerSelectionWizardPage.this.onPlayersTableSelectionChanged();
            }
        });
        this._playersTable = tableViewer;
        tableViewer.setLabelProvider((IBaseLabelProvider)new ExternalPlayerLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new ExternalPlayerContentProvider());
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        GridData gridData = new GridData(768);
        gridData.heightHint = 110;
        table.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(274);
        tableColumn.setText("Name");
        tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(136);
        tableColumn.setText("State");
        Composite playerFrame = new Composite(composite, 0);
        playerFrame.setLayout((Layout)new FillLayout());
        this._playerFrame = playerFrame;
        GridData gridData2 = new GridData(784);
        gridData2.heightHint = 0;
        playerFrame.setLayoutData((Object)gridData2);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PlayerSelectionWizardPage.this.onDiscover();
            }
        });
        gridData2 = new GridData(128);
        gridData2.widthHint = 90;
        button.setLayoutData((Object)gridData2);
        button.setText("&Discover");
        this.setControl((Control)main);
        main.applyFrameStyle();
        this.initPlayerSelectionWizardPage();
    }

    protected SettingsDocument getSettings() {
        return ((PlayerSelectionWizard)this.getWizard()).getSettings();
    }

    protected void initPlayerSelectionWizardPage() {
        this._playersTable.setInput(new Object());
        Players players = this.getSettings().getPlayers();
        if (players.hasActivePlayer()) {
            this.setSelectedPlayer(players.getActivePlayer());
        }
        this.onPlayersTableSelectionChanged();
    }

    protected void onPlayersTableDoubleClick() {
    }

    public void onPlayersTableSelectionChanged() {
        boolean ok = this.hasSelectedPlayer();
        if (ok) {
            Player player = this.getSelectedPlayer();
            ok = player.getPlayerAvailableState().isAvailable();
        }
        this.setPageComplete(ok);
    }

    public void onDiscover() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                boolean stateChanged = false;
                SettingsDocument settings = PlayerSelectionWizardPage.this.getSettings();
                Players.Iterator players = settings.getPlayers().iterator();
                while (players.hasNext()) {
                    PlayerAvailableState newState;
                    Player player = players.next();
                    ExternalPlayer exPlayer = player.toExternalPlayer();
                    PlayerAvailableState nowState = player.getPlayerAvailableState();
                    try {
                        IPlayer p = exPlayer.create(PlayerSelectionWizardPage.this._playerFrame, 2048);
                        p.dispose();
                        p.getFrame().dispose();
                        newState = PlayerAvailableState.available;
                    }
                    catch (Exception exception) {
                        newState = PlayerAvailableState.notAvailable;
                    }
                    player.setPlayerAvailableState(newState);
                    if (nowState == newState) continue;
                    stateChanged = true;
                }
                if (stateChanged) {
                    Main main = Main.getInstance();
                    main.setSettings(settings);
                    main.saveSettings();
                }
            }
        });
        this._playersTable.refresh();
        this.onPlayersTableSelectionChanged();
    }

    protected void setSelectedPlayer(Player player) {
        this._playersTable.setSelection((ISelection)new StructuredSelection((Object)player));
    }

    public Player getSelectedPlayer() {
        return (Player)((IStructuredSelection)this._playersTable.getSelection()).getFirstElement();
    }

    public boolean hasSelectedPlayer() {
        return this.getSelectedPlayer() != null;
    }
}

