/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.model;

import com.o3tt3rli.xml.XmlNode;
import com.o3tt3rli.xml.XmlNodes;
import java.io.File;
import mpplayer.MpplayerException;
import mpplayer.lang.FileProperty;
import mpplayer.lang.StringElementProperty;
import mpplayer.model.Delegate;
import mpplayer.model.Track;
import mpplayer.model.Tracks;
import mpplayer.model.TracksProperty;

public class PlayListDocument {
    public final Delegate delegate = new Delegate();
    public final TracksProperty tracks = new TracksProperty("tracks"){

        public Tracks get() {
            Tracks result = new Tracks();
            XmlNodes.Iterator tracks = PlayListDocument.this.delegate.get().getAll("track").iterator();
            while (tracks.hasNext()) {
                result.add(new Track(tracks.next()));
            }
            return result;
        }
    };
    public final FileProperty file = new FileProperty("file");

    public static PlayListDocument create() {
        return new PlayListDocument(new XmlNode("playlist"));
    }

    public static PlayListDocument load(File aFile) {
        PlayListDocument doc = new PlayListDocument(new XmlNode(aFile));
        doc.file.set(aFile);
        return doc;
    }

    public void save() {
        this.save(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(File aFile) {
        if (aFile == null) {
            if (!this.file.isSet()) throw new MpplayerException("Unable to save document. It has not yet been loaded.");
            aFile = this.file.get();
        } else {
            this.file.set(aFile);
        }
        this.delegate.get().save(aFile);
    }

    public PlayListDocument(XmlNode aDelegate) {
        this.delegate.set(aDelegate);
    }

    public Track addTrack() {
        return new Track().create(this.delegate.get().add("track"));
    }

    public static void main(String[] args) {
        PlayListDocument d = PlayListDocument.create();
        Track t = d.addTrack();
        t.file.set("d:/qq.mp4");
        t.title.set("Global Distinct");
        System.out.println(d.delegate.get().toPrettyXml());
        Tracks.Iterator tracks = d.tracks.get().iterator();
        while (tracks.hasNext()) {
            t = tracks.next();
            StringElementProperty f = t.file;
            System.out.println(String.valueOf(f.getName()) + "=" + f.get());
        }
    }
}

