/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PlayerAvailableState {
    public static final NotYetDiscovered notYetDiscovered = new NotYetDiscovered();
    public static final Available available = new Available();
    public static final NotAvailable notAvailable = new NotAvailable();
    private static Map _name2ItemMap;
    private static List _all;
    public static final String NAME = "PlayerAvailableState";

    protected PlayerAvailableState() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public static PlayerAvailableState valueOf(String name, PlayerAvailableState defaultValue) {
        Map map = PlayerAvailableState.getName2ItemMap();
        PlayerAvailableState item = map.containsKey(name) ? (PlayerAvailableState)map.get(name) : defaultValue;
        return item;
    }

    public static PlayerAvailableState valueOf(String name) {
        PlayerAvailableState i_t_e_m = PlayerAvailableState.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, PlayerAvailableState> map = new HashMap<String, PlayerAvailableState>();
            Iterator all = PlayerAvailableState.getAll().iterator();
            while (all.hasNext()) {
                PlayerAvailableState item = (PlayerAvailableState)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    public boolean isNotYetDiscovered() {
        return this.equals(notYetDiscovered);
    }

    public boolean isAvailable() {
        return this.equals(available);
    }

    public boolean isNotAvailable() {
        return this.equals(notAvailable);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(notYetDiscovered, available, notAvailable);
        }
        return _all;
    }

    public static class NotYetDiscovered
    extends PlayerAvailableState {
        protected NotYetDiscovered() {
        }

        public String getName() {
            return "notYetDiscovered";
        }
    }

    public static class Available
    extends PlayerAvailableState {
        protected Available() {
        }

        public String getName() {
            return "available";
        }
    }

    public static class NotAvailable
    extends PlayerAvailableState {
        protected NotAvailable() {
        }

        public String getName() {
            return "notAvailable";
        }
    }
}

