/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.playlist;

import com.o3tt3rli.io.XFile;
import com.o3tt3rli.xml.XmlNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import mpplayer.MpplayerException;
import mpplayer.lang.Strings;
import mpplayer.model.PlayListDocument;
import mpplayer.model.Track;

public abstract class PlayListReader {
    public static final PlayListReader mppp = new PlayListReader("mpppl"){

        public String getTitle() {
            return "Musician's Practicing Player";
        }

        public void read(PlayListDocument playList, File file) {
            playList.delegate.get().addChildren(new XmlNode(file));
        }
    };
    public static final PlayListReader rmp = new PlayListReader("rmp"){

        public String getTitle() {
            return "RealOne Player";
        }

        public void read(PlayListDocument playList, File file) {
            String xml = XFile.getContents((File)file);
            int pos = 0;
            do {
                if ((pos = xml.indexOf("<TRACK>", pos)) == -1) continue;
                pos = xml.indexOf("<TITLE>", pos);
                String title = xml.substring(pos + "<TITLE>".length(), xml.indexOf("<", pos + 1));
                pos = xml.indexOf("<FILENAME>", pos);
                String track = xml.substring(pos + "<FILENAME>".length(), xml.indexOf("<", pos + 1));
                Track newTrack = playList.addTrack();
                newTrack.title.set(title);
                newTrack.file.set(track);
            } while (pos != -1);
        }
    };
    public static final PlayListReader m3u = new PlayListReader("m3u"){

        public String getTitle() {
            return "m3u";
        }

        public void read(PlayListDocument playList, File file) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                Strings lines = new Strings();
                while ((line = reader.readLine()) != null) {
                    lines.add(line.trim());
                }
                if (!lines.isEmpty()) {
                    String m3uPath = file.getAbsolutePath().replace('\\', '/');
                    m3uPath = m3uPath.substring(0, m3uPath.lastIndexOf(47) + 1);
                    boolean isExtendFormat = lines.get(0).equals("#EXTM3U");
                    int i = isExtendFormat ? 1 : 0;
                    int n = lines.size();
                    while (i < n) {
                        line = lines.get(i);
                        String title = null;
                        String track = null;
                        if (isExtendFormat) {
                            if (line.startsWith("#EXTINF")) {
                                title = line.substring(line.indexOf(44) + 1).trim();
                                track = lines.get(i + 1);
                                ++i;
                            }
                        } else if (!line.startsWith("#")) {
                            title = track = line;
                        }
                        if (title != null && track != null) {
                            Track newTrack = playList.addTrack();
                            newTrack.title.set(title);
                            newTrack.file.set(track);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                throw new MpplayerException(e);
            }
        }
    };
    private String _name;

    protected void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    protected PlayListReader(String name) {
        this.setName(name);
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    public static PlayListReader parse(String name) {
        void var1_1;
        PlayListReader playListReader;
        if ("mpppl".equals(name)) {
            playListReader = mppp;
        } else if ("rmp".equals(name)) {
            playListReader = rmp;
        } else if ("m3u".equals(name)) {
            playListReader = m3u;
        } else {
            throw new MpplayerException("name not in enumeration: " + name);
        }
        return var1_1;
    }

    public boolean isMppp() {
        return this.equals(mppp);
    }

    public boolean isRmp() {
        return this.equals(rmp);
    }

    public boolean isM3u() {
        return this.equals(m3u);
    }

    public static List getAll() {
        ArrayList<PlayListReader> list = new ArrayList<PlayListReader>();
        list.add(mppp);
        list.add(rmp);
        list.add(m3u);
        return list;
    }

    public abstract void read(PlayListDocument var1, File var2);

    public abstract String getTitle();

    public String getFilter() {
        return "*" + this.getExtension();
    }

    public String getExtension() {
        return "." + this.getName();
    }

    public String getFilterName() {
        return String.valueOf(this.getTitle()) + " (" + this.getFilter() + ")";
    }

    public PlayListDocument create(File file) {
        PlayListDocument playList = PlayListDocument.create();
        this.read(playList, file);
        return playList;
    }

    public static PlayListReader parse(File file) {
        PlayListReader reader = null;
        String fileName = file.getName();
        int pos = fileName.lastIndexOf(46);
        if (pos != -1) {
            String ext = fileName.substring(pos + 1).toLowerCase();
            try {
                reader = PlayListReader.parse(ext);
            }
            catch (Exception exception) {}
        }
        return reader;
    }
}

