/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.realone;

import mpplayer.ExternalPlayer;
import mpplayer.PlayState;
import mpplayer.win32.AbstractOlePlayer;
import mpplayer.win32.realone.RealOneDispId;
import mpplayer.win32.realone.RealOneEvent;
import mpplayer.win32.realone.RealOnePlayState;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;

public class RealOne
extends AbstractOlePlayer {
    public RealOne(Composite parent, int style, String progId) {
        super(parent, style, progId);
        this.getSite().addEventListener(RealOneEvent.playStateChange.getValue(), new OleListener(){

            public void handleEvent(OleEvent event) {
                RealOne.this.onPlayStateChange(event);
            }
        });
    }

    protected void onClipClosed(OleEvent event) {
        System.out.println("clip closed");
    }

    protected void onPlayStateChange(OleEvent event) {
    }

    public void load(String media) {
        this.getControl().invokeNoReply(RealOneDispId.setSource.getValue(), new Variant[]{new Variant(media)});
        this.play();
    }

    public void play() {
        this.getControl().invokeNoReply(RealOneDispId.doPlay.getValue());
    }

    public void pause() {
        this.getControl().invokeNoReply(RealOneDispId.doPause.getValue());
    }

    public void stop() {
        this.getControl().invokeNoReply(RealOneDispId.doStop.getValue());
    }

    public float getPlayPosition() {
        return this.getControl().invoke(RealOneDispId.getPosition.getValue()).getFloat() / 1000.0f;
    }

    public void setCurrentPlayPosition(float position) {
        this.getControl().invokeNoReply(RealOneDispId.setPosition.getValue(), new Variant[]{new Variant(position * 1000.0f)});
    }

    public PlayState getPlayState() {
        PlayState ps;
        try {
            ps = RealOnePlayState.valueOf(this.getControl().invoke(RealOneDispId.getPlayState.getValue()).getInt()).toPlayState();
        }
        catch (Exception exception) {
            ps = PlayState.undefined;
        }
        return ps;
    }

    public float getCurrentMediaDuration() {
        return this.getControl().invoke(RealOneDispId.getLength.getValue()).getFloat() / 1000.0f;
    }

    public String getTitle() {
        return ExternalPlayer.realOne.getTitle();
    }
}

