/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.wmp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class WmpEvent {
    public static final PlayStateChange playStateChange = new PlayStateChange();
    public static final StayTunedYetMoreToCome stayTunedYetMoreToCome = new StayTunedYetMoreToCome();
    private static Map _name2ItemMap;
    private static Map _value2ItemMap;
    private static List _all;

    protected WmpEvent() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract int getValue();

    public static WmpEvent valueOf(String name, WmpEvent defaultValue) {
        Map map = WmpEvent.getName2ItemMap();
        WmpEvent item = map.containsKey(name) ? (WmpEvent)map.get(name) : defaultValue;
        return item;
    }

    public static WmpEvent valueOf(String name) {
        WmpEvent i_t_e_m = WmpEvent.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    public static WmpEvent valueOf(int value) {
        WmpEvent item = WmpEvent.valueOf(value, null);
        if (item == null) {
            throw new IllegalArgumentException("value not in enumeration: " + value);
        }
        return item;
    }

    public static WmpEvent valueOf(int value, WmpEvent defaultValue) {
        Integer aValue = new Integer(value);
        Map map = WmpEvent.getValue2ItemMap();
        WmpEvent item = map.containsKey(aValue) ? (WmpEvent)map.get(aValue) : defaultValue;
        return item;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, WmpEvent> map = new HashMap<String, WmpEvent>();
            Iterator all = WmpEvent.getAll().iterator();
            while (all.hasNext()) {
                WmpEvent item = (WmpEvent)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    protected static Map getValue2ItemMap() {
        if (_value2ItemMap == null) {
            HashMap<Integer, WmpEvent> map = new HashMap<Integer, WmpEvent>();
            Iterator all = WmpEvent.getAll().iterator();
            while (all.hasNext()) {
                WmpEvent item = (WmpEvent)all.next();
                map.put(new Integer(item.getValue()), item);
            }
            _value2ItemMap = map;
        }
        return _value2ItemMap;
    }

    public boolean isPlayStateChange() {
        return this.equals(playStateChange);
    }

    public boolean isStayTunedYetMoreToCome() {
        return this.equals(stayTunedYetMoreToCome);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(playStateChange, stayTunedYetMoreToCome);
        }
        return _all;
    }

    public static class PlayStateChange
    extends WmpEvent {
        protected PlayStateChange() {
        }

        public String getName() {
            return "playStateChange";
        }

        public int getValue() {
            return 5101;
        }
    }

    public static class StayTunedYetMoreToCome
    extends WmpEvent {
        protected StayTunedYetMoreToCome() {
        }

        public String getName() {
            return "stayTunedYetMoreToCome";
        }

        public int getValue() {
            return 12345;
        }
    }
}

