/*
 * Decompiled with CFR 0.152.
 */
package mpplayer.win32.wmp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpplayer.PlayState;

public abstract class WmpPlayState {
    public static final Undefined undefined = new Undefined();
    public static final Stopped stopped = new Stopped();
    public static final Paused paused = new Paused();
    public static final Playing playing = new Playing();
    public static final ScanForward scanForward = new ScanForward();
    public static final ScanReverse scanReverse = new ScanReverse();
    public static final Buffering buffering = new Buffering();
    public static final Waiting waiting = new Waiting();
    public static final MediaEnded mediaEnded = new MediaEnded();
    public static final Transitioning transitioning = new Transitioning();
    public static final Ready ready = new Ready();
    public static final Reconnecting reconnecting = new Reconnecting();
    public static final Last last = new Last();
    private static Map _name2ItemMap;
    private static Map _value2ItemMap;
    private static List _all;

    protected WmpPlayState() {
    }

    public String toString() {
        return this.getName();
    }

    public abstract String getName();

    public abstract int getValue();

    public static WmpPlayState valueOf(String name, WmpPlayState defaultValue) {
        Map map = WmpPlayState.getName2ItemMap();
        WmpPlayState item = map.containsKey(name) ? (WmpPlayState)map.get(name) : defaultValue;
        return item;
    }

    public static WmpPlayState valueOf(String name) {
        WmpPlayState i_t_e_m = WmpPlayState.valueOf(name, null);
        if (i_t_e_m == null) {
            throw new IllegalArgumentException("name not in enumeration: " + name);
        }
        return i_t_e_m;
    }

    public static WmpPlayState valueOf(int value) {
        WmpPlayState item = WmpPlayState.valueOf(value, null);
        if (item == null) {
            throw new IllegalArgumentException("value not in enumeration: " + value);
        }
        return item;
    }

    public static WmpPlayState valueOf(int value, WmpPlayState defaultValue) {
        Integer aValue = new Integer(value);
        Map map = WmpPlayState.getValue2ItemMap();
        WmpPlayState item = map.containsKey(aValue) ? (WmpPlayState)map.get(aValue) : defaultValue;
        return item;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected static Map getName2ItemMap() {
        if (_name2ItemMap == null) {
            HashMap<String, WmpPlayState> map = new HashMap<String, WmpPlayState>();
            Iterator all = WmpPlayState.getAll().iterator();
            while (all.hasNext()) {
                WmpPlayState item = (WmpPlayState)all.next();
                map.put(item.getName(), item);
            }
            _name2ItemMap = map;
        }
        return _name2ItemMap;
    }

    protected static Map getValue2ItemMap() {
        if (_value2ItemMap == null) {
            HashMap<Integer, WmpPlayState> map = new HashMap<Integer, WmpPlayState>();
            Iterator all = WmpPlayState.getAll().iterator();
            while (all.hasNext()) {
                WmpPlayState item = (WmpPlayState)all.next();
                map.put(new Integer(item.getValue()), item);
            }
            _value2ItemMap = map;
        }
        return _value2ItemMap;
    }

    public boolean isUndefined() {
        return this.equals(undefined);
    }

    public boolean isStopped() {
        return this.equals(stopped);
    }

    public boolean isPaused() {
        return this.equals(paused);
    }

    public boolean isPlaying() {
        return this.equals(playing);
    }

    public boolean isScanForward() {
        return this.equals(scanForward);
    }

    public boolean isScanReverse() {
        return this.equals(scanReverse);
    }

    public boolean isBuffering() {
        return this.equals(buffering);
    }

    public boolean isWaiting() {
        return this.equals(waiting);
    }

    public boolean isMediaEnded() {
        return this.equals(mediaEnded);
    }

    public boolean isTransitioning() {
        return this.equals(transitioning);
    }

    public boolean isReady() {
        return this.equals(ready);
    }

    public boolean isReconnecting() {
        return this.equals(reconnecting);
    }

    public boolean isLast() {
        return this.equals(last);
    }

    public static List getAll() {
        if (_all == null) {
            _all = Arrays.asList(undefined, stopped, paused, playing, scanForward, scanReverse, buffering, waiting, mediaEnded, transitioning, ready, reconnecting, last);
        }
        return _all;
    }

    public PlayState toPlayState() {
        PlayState ps = this.isStopped() ? PlayState.stopped : (this.isPlaying() ? PlayState.playing : (this.isPaused() ? PlayState.paused : PlayState.undefined));
        return ps;
    }

    public static class Undefined
    extends WmpPlayState {
        protected Undefined() {
        }

        public String getName() {
            return "undefined";
        }

        public int getValue() {
            return 0;
        }
    }

    public static class Stopped
    extends WmpPlayState {
        protected Stopped() {
        }

        public String getName() {
            return "stopped";
        }

        public int getValue() {
            return 1;
        }
    }

    public static class Paused
    extends WmpPlayState {
        protected Paused() {
        }

        public String getName() {
            return "paused";
        }

        public int getValue() {
            return 2;
        }
    }

    public static class Playing
    extends WmpPlayState {
        protected Playing() {
        }

        public String getName() {
            return "playing";
        }

        public int getValue() {
            return 3;
        }
    }

    public static class ScanForward
    extends WmpPlayState {
        protected ScanForward() {
        }

        public String getName() {
            return "scanForward";
        }

        public int getValue() {
            return 4;
        }
    }

    public static class ScanReverse
    extends WmpPlayState {
        protected ScanReverse() {
        }

        public String getName() {
            return "scanReverse";
        }

        public int getValue() {
            return 5;
        }
    }

    public static class Buffering
    extends WmpPlayState {
        protected Buffering() {
        }

        public String getName() {
            return "buffering";
        }

        public int getValue() {
            return 6;
        }
    }

    public static class Waiting
    extends WmpPlayState {
        protected Waiting() {
        }

        public String getName() {
            return "waiting";
        }

        public int getValue() {
            return 7;
        }
    }

    public static class MediaEnded
    extends WmpPlayState {
        protected MediaEnded() {
        }

        public String getName() {
            return "mediaEnded";
        }

        public int getValue() {
            return 8;
        }
    }

    public static class Transitioning
    extends WmpPlayState {
        protected Transitioning() {
        }

        public String getName() {
            return "transitioning";
        }

        public int getValue() {
            return 9;
        }
    }

    public static class Ready
    extends WmpPlayState {
        protected Ready() {
        }

        public String getName() {
            return "ready";
        }

        public int getValue() {
            return 10;
        }
    }

    public static class Reconnecting
    extends WmpPlayState {
        protected Reconnecting() {
        }

        public String getName() {
            return "reconnecting";
        }

        public int getValue() {
            return 11;
        }
    }

    public static class Last
    extends WmpPlayState {
        protected Last() {
        }

        public String getName() {
            return "last";
        }

        public int getValue() {
            return 12;
        }
    }
}

