/*
 * Decompiled with CFR 0.152.
 */
package com.centralnexus.input;

import com.centralnexus.input.Joystick;
import com.centralnexus.input.JoystickListener;

class JoystickNotifier
implements Runnable {
    private Joystick jstick;
    private Thread pollingThread = null;
    private int interval = 50;
    private JoystickListener[] joyListeners = new JoystickListener[0];
    private Joystick[] joysticks = new Joystick[0];
    float[] axisValues = new float[7];
    private float[] axisValuesOld = new float[7];
    int buttonValues = 0;
    private int buttonValuesOld = 0;

    JoystickNotifier(Joystick joystick) {
        this.jstick = joystick;
    }

    public void start() {
        this.pollingThread.start();
    }

    public synchronized void addJoystickListener(Joystick joystick, JoystickListener joystickListener) {
        if (joystickListener != null) {
            JoystickListener[] joystickListenerArray = new JoystickListener[this.joyListeners.length + 1];
            Joystick[] joystickArray = new Joystick[this.joyListeners.length + 1];
            System.arraycopy(this.joyListeners, 0, joystickListenerArray, 0, this.joyListeners.length);
            System.arraycopy(this.joysticks, 0, joystickArray, 0, this.joysticks.length);
            joystickListenerArray[this.joyListeners.length] = joystickListener;
            joystickArray[this.joysticks.length] = joystick;
            this.joyListeners = joystickListenerArray;
            this.joysticks = joystickArray;
            this.joyListeners[this.joyListeners.length - 1].joystickAxisChanged(this.joysticks[this.joyListeners.length - 1]);
            this.joyListeners[this.joyListeners.length - 1].joystickButtonChanged(this.joysticks[this.joyListeners.length - 1]);
            if (this.pollingThread == null) {
                this.pollingThread = new Thread(this);
                this.pollingThread.start();
            }
        }
    }

    public synchronized void removeJoystickListener(Joystick joystick, JoystickListener joystickListener) {
        if (joystickListener != null && this.joyListeners.length > 0) {
            JoystickListener[] joystickListenerArray = new JoystickListener[this.joyListeners.length - 1];
            Joystick[] joystickArray = new Joystick[this.joyListeners.length - 1];
            int n = 0;
            while (n < joystickListenerArray.length && this.joyListeners[n] != joystickListener && this.joysticks[n] != joystick) {
                joystickListenerArray[n] = this.joyListeners[n];
                joystickArray[n] = this.joysticks[n];
                ++n;
            }
            if (n < this.joyListeners.length) {
                if (0 < joystickListenerArray.length) {
                    System.arraycopy(this.joyListeners, n + 1, joystickListenerArray, n, joystickListenerArray.length - n);
                    System.arraycopy(this.joysticks, n + 1, joystickArray, n, joystickArray.length - n);
                }
                this.joyListeners = joystickListenerArray;
                this.joysticks = joystickArray;
            }
        }
    }

    public final synchronized void notifyJoystickListeners() {
        this.jstick.poll();
        boolean bl = false;
        int n = 0;
        while (n < this.axisValues.length) {
            if (this.axisValues[n] != this.axisValuesOld[n]) {
                bl = true;
                break;
            }
            ++n;
        }
        int n2 = this.joyListeners.length - 1;
        while (n2 >= 0) {
            if (bl) {
                this.joyListeners[n2].joystickAxisChanged(this.joysticks[n2]);
            }
            if (this.buttonValues != this.buttonValuesOld) {
                this.joyListeners[n2].joystickButtonChanged(this.joysticks[n2]);
            }
            --n2;
        }
        this.buttonValuesOld = this.buttonValues;
        System.arraycopy(this.axisValues, 0, this.axisValuesOld, 0, this.axisValues.length);
    }

    public void setPollInterval(int n) {
        this.interval = n;
    }

    public int getPollInterval() {
        return this.interval;
    }

    public void run() {
        while (this.joyListeners.length > 0) {
            this.notifyJoystickListeners();
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                this.pollingThread = null;
                return;
            }
        }
        this.pollingThread = null;
    }
}

